/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.net.URI;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.cli.InstallUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;

public class CodewindManager {
    private static CodewindManager codewindManager;
    InstallStatus installStatus = InstallStatus.UNKNOWN;
    InstallerStatus installerStatus = null;
    String installerErrorMsg = null;

    private CodewindManager() {
    }

    public static synchronized CodewindManager getManager() {
        if (codewindManager == null) {
            codewindManager = new CodewindManager();
        }
        return codewindManager;
    }

    public InstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public String getInstallerErrorMsg() {
        return this.installerErrorMsg;
    }

    public synchronized void refreshInstallStatus() {
        String urlStr = null;
        this.installerErrorMsg = null;
        try {
            this.installStatus = InstallUtil.getInstallStatus();
            LocalConnection localConnection = ConnectionManager.getManager().getLocalConnection();
            if (localConnection != null) {
                if (this.installStatus.isStarted()) {
                    urlStr = this.installStatus.getURL();
                    if (!localConnection.isConnected()) {
                        URI uri = new URI(urlStr);
                        localConnection.setBaseURI(uri);
                        localConnection.connect();
                    }
                } else {
                    localConnection.disconnect();
                    localConnection.setBaseURI(null);
                }
            }
            return;
        }
        catch (Exception e) {
            Logger.log("An error occurred trying to get the Codewind install status.", e);
            System.out.println("*** An error occurred trying to get the Codewind install status. " + e.getLocalizedMessage());
            this.installerErrorMsg = e.getLocalizedMessage();
            this.installStatus = InstallStatus.UNKNOWN;
            return;
        }
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateAll();
    }

    public boolean isSupportedVersion(String version) {
        return CodewindConnection.isSupportedVersion(version);
    }

    public void refresh() {
        this.refreshInstallStatus();
        for (CodewindConnection conn : ConnectionManager.getManager().activeConnections()) {
            if (!conn.isConnected()) continue;
            conn.refreshApps(null);
        }
    }

    public boolean hasActiveApplications() {
        for (CodewindConnection conn : ConnectionManager.getManager().activeConnections()) {
            for (CodewindApplication app : conn.getApps()) {
                if (!app.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

