/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class TreeAction<T>
extends AnAction {
    private final String text;
    private final Class<T> type;
    private final Function<T, Task.Backgroundable> taskFactory;

    public TreeAction(String text, Class<T> type, Function<T, Task.Backgroundable> taskFactory) {
        super(text);
        this.text = text;
        this.type = type;
        this.taskFactory = taskFactory;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TreeAction.$$$reportNull$$$0(0);
        }
        this.getSelection(e).ifPresent(value -> ProgressManager.getInstance().run((Task)this.taskFactory.apply(value)));
    }

    protected Optional<T> getSelection(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            TreeAction.$$$reportNull$$$0(1);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            Logger.logWarning("unrecognized component for action " + this.text + ": " + data);
            System.out.println("unrecognized component for action " + this.text + ": " + data);
            return Optional.empty();
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        Object node = treePath.getLastPathComponent();
        if (!this.type.isInstance(node)) {
            Logger.logWarning("unrecognized node for action " + this.text + ": " + node);
            System.out.println("unrecognized node for action " + this.text + ": " + node);
            return Optional.empty();
        }
        return Optional.of(this.type.cast(node));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/TreeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

