/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.wizard;

import com.intellij.ide.wizard.AbstractWizardEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtil;
import java.util.List;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ProjectTypeInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.BindProjectModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AddExistingProjectWizard
extends AbstractWizardEx {
    private BindProjectModel model;
    private CodewindConnection connection;
    private Project intellijProject;

    public AddExistingProjectWizard(String title, @Nullable Project project, List<AbstractBindProjectWizardStep> steps, @Nullable CodewindConnection connection) {
        super(title, project, steps);
        this.connection = connection;
        this.intellijProject = project;
        this.model = new BindProjectModel();
    }

    protected boolean canFinish() {
        return super.canFinish();
    }

    protected void doNextAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        AbstractBindProjectWizardStep nextStepObject = (AbstractBindProjectWizardStep)this.getNextStepObject();
        nextStepObject.onStepEntering(this.model);
        super.doNextAction();
        nextStepObject.postDoNextStep(this.model);
    }

    protected void doPreviousAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        super.doPreviousAction();
    }

    protected void doOKAction() {
        AbstractBindProjectWizardStep currentStepObject = (AbstractBindProjectWizardStep)this.getCurrentStepObject();
        currentStepObject.onStepLeaving(this.model);
        final String name = PathUtil.getFileName((String)this.model.getProjectPath());
        final ProjectInfo projectInfo = this.model.getProjectInfo();
        final ProjectTypeInfo typeInfo = this.model.getProjectTypeInfo();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    String path = AddExistingProjectWizard.this.model.getProjectPath();
                    if (projectInfo != null && projectInfo.type.getId().equals(typeInfo.getId())) {
                        ProjectUtil.bindProject(name, path, projectInfo.language.getId(), projectInfo.type.getId(), AddExistingProjectWizard.this.connection.getConid(), indicator);
                    } else {
                        ProjectTypeInfo.ProjectSubtypeInfo subtypeInfo = AddExistingProjectWizard.this.model.getSubtypeInfo();
                        String language = subtypeInfo.id;
                        if (subtypeInfo != null) {
                            ProjectUtil.validateProject(name, path, typeInfo.getId() + ":" + subtypeInfo.id, AddExistingProjectWizard.this.connection.getConid(), indicator);
                        }
                        ProjectUtil.bindProject(name, path, language, typeInfo.getId(), AddExistingProjectWizard.this.connection.getConid(), indicator);
                    }
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
        }, CodewindUIBundle.message("BindProjectWizardJobLabel", name), false, this.intellijProject);
        super.doOKAction();
        try {
            String selectedProjectPath = this.model.getProjectPath();
            Project[] openedProjects = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < openedProjects.length; ++i) {
                Project openedProject = openedProjects[i];
                @SystemIndependent String basePath = openedProject.getBasePath();
                if (!selectedProjectPath.equals(basePath)) continue;
                WindowManager.getInstance().getFrame(openedProject).setVisible(true);
                return;
            }
            Project targetProject = com.intellij.ide.impl.ProjectUtil.openOrImport((String)this.model.getProjectPath(), (Project)this.intellijProject, (boolean)false);
            CodewindToolWindowHelper.openWindow(targetProject);
        }
        catch (Exception ex) {
            Logger.log(ex);
        }
    }

    @Nullable
    protected String getHelpID() {
        return null;
    }
}

