/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.codewind.openapi.ui.Activator;
import org.eclipse.codewind.openapi.ui.Constants;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.codewind.openapi.ui.commands.AbstractOpenApiGeneratorCommand;
import org.eclipse.codewind.openapi.ui.commands.PostGenCommand;
import org.eclipse.codewind.openapi.ui.wizard.AbstractGenerateWizardPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractGenerateWizard
extends Wizard
implements INewWizard {
    protected AbstractGenerateWizardPage page;
    protected ISelection selection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    protected abstract AbstractOpenApiGeneratorCommand getCommand();

    public void addPage(IWizardPage p) {
        this.page = (AbstractGenerateWizardPage)p;
        super.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IResource pomFile;
        IResource ignoreFile;
        final AbstractOpenApiGeneratorCommand cmd = this.getCommand();
        IProject project = this.page.getProject();
        if (this.page.getOutputFolder().equals(project.getFullPath().toString())) {
            ignoreFile = project.findMember(".openapi-generator-ignore");
        } else {
            IFolder outputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.page.getOutputFolder()));
            ignoreFile = outputFolder.findMember(".openapi-generator-ignore");
        }
        if (this.page.getOutputFolder().equals(project.getFullPath().toString())) {
            pomFile = project.findMember("pom.xml");
        } else {
            IFolder outputFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.page.getOutputFolder()));
            pomFile = outputFolder.findMember("pom.xml");
        }
        boolean ignoreFileExists = ignoreFile != null && ignoreFile.exists();
        cmd.setPomFileExists(pomFile != null && pomFile.exists());
        boolean doContinue = this.page.preCodeGen(ignoreFileExists);
        if (!doContinue) {
            this.performCancel();
            return true;
        }
        final Constants.PROJECT_TYPE projectType = this.page.getProjectType();
        cmd.setCodewindProjectTypeId(this.page.getCodewindProjectTypeId());
        final PostGenCommand postGenCommand = new PostGenCommand(project, projectType, ignoreFileExists, this.page.getOutputFolder(), this.page.getPomFileBackupName());
        Job job = new Job(Messages.JOB_GENERATING){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    cmd.run(monitor);
                    if (projectType == Constants.PROJECT_TYPE.MAVEN) {
                        postGenCommand.run(monitor);
                    }
                }
                catch (InvocationTargetException e) {
                    Activator.log(1, "Generator failed: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    Activator.log(1, "Generator job was cancelled");
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setPriority(30);
        job.schedule(1000L);
        return true;
    }
}

