/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.comma.java.JCmd;

public class JCmdExecutor {
    public Result run(JCmd cmd) throws IOException, InterruptedException {
        Process ps = Runtime.getRuntime().exec(cmd.toArray());
        ps.waitFor();
        return new Result(ps.getErrorStream(), ps.getInputStream(), ps.exitValue());
    }

    public Result run(JCmd cmd, File workingDir) throws IOException, InterruptedException {
        Process ps = Runtime.getRuntime().exec(cmd.toArray(), null, workingDir);
        ps.waitFor();
        return new Result(ps.getErrorStream(), ps.getInputStream(), ps.exitValue());
    }

    public Result run(JCmd cmd, String workingDir) throws IOException, InterruptedException {
        Process ps = Runtime.getRuntime().exec(cmd.toArray(), null, new File(workingDir));
        ps.waitFor();
        return new Result(ps.getErrorStream(), ps.getInputStream(), ps.exitValue());
    }

    public class Result {
        private InputStream errorStream;
        private InputStream inputStream;
        private int exitCode;

        private Result(InputStream errorStream, InputStream inputStream, int exitCode) {
            this.errorStream = errorStream;
            this.inputStream = inputStream;
            this.exitCode = exitCode;
        }

        public InputStream getErrorStream() {
            return this.errorStream;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

