/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.metadata;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.internal.p2.metadata.OmniVersion;
import org.eclipse.equinox.internal.p2.metadata.VersionFormat;
import org.eclipse.equinox.internal.p2.metadata.VersionParser;
import org.eclipse.equinox.internal.p2.metadata.VersionVector;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.VersionFormatException;

public abstract class Version
implements Comparable<Version>,
Serializable {
    public static final String RAW_PREFIX = "raw:";
    private static WeakHashMap<String, SoftReference<Version>> POOL = new WeakHashMap();
    public static final Version MAX_VERSION = OmniVersion.createMaxVersion();
    public static final Version emptyVersion = OmniVersion.createMinVersion();
    private static final long serialVersionUID = 6218979149720923857L;

    public static IVersionFormat compile(String format) throws VersionFormatException {
        return VersionFormat.compile(format, 0, format.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version create(String version) {
        Version v = null;
        if (version != null && version.length() > 0) {
            SoftReference<Version> vRef = POOL.get(version);
            Version version2 = v = vRef != null ? vRef.get() : null;
            if (v == null) {
                v = VersionParser.parse(version, 0, version.length());
                WeakHashMap<String, SoftReference<Version>> weakHashMap = POOL;
                synchronized (weakHashMap) {
                    POOL.put(version, new SoftReference<Version>(v));
                }
            }
        }
        return v;
    }

    public static Version createOSGi(int major, int minor, int micro) {
        return Version.createOSGi(major, minor, micro, null);
    }

    public static Version createOSGi(int major, int minor, int micro, String qualifier) {
        Object logicQualifier;
        if (qualifier == null || qualifier.length() == 0) {
            if (major == 0 && minor == 0 && micro == 0) {
                return emptyVersion;
            }
            logicQualifier = "";
        } else {
            logicQualifier = qualifier.equals("zzz") ? VersionVector.MAXS_VALUE : qualifier;
        }
        return new OSGiVersion(major, minor, micro, (Comparable<? extends Object>)logicQualifier);
    }

    public static Version parseVersion(String version) {
        if (version == null || version.length() == 0) {
            return emptyVersion;
        }
        Version v = Version.create(version);
        return v == null ? emptyVersion : v;
    }

    public abstract IVersionFormat getFormat();

    public abstract String getOriginal();

    public abstract Comparable<?> getPad();

    public abstract Comparable<?> getSegment(int var1);

    public abstract int getSegmentCount();

    public abstract boolean isOSGiCompatible();

    public String toString() {
        StringBuffer buf = new StringBuffer(20);
        this.toString(buf);
        return buf.toString();
    }

    public abstract void toString(StringBuffer var1);
}

