/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.comma.types.types.Import;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.DefaultHyperlinkDetector;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

public class CommaHyperLinkDetector
extends DefaultHyperlinkDetector {
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] hyperlinks = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        if (hyperlinks == null) {
            return this.createHyperLinks(textViewer, region);
        }
        return hyperlinks;
    }

    public IHyperlink[] createHyperLinks(ITextViewer textViewer, final IRegion region) {
        IDocument _document = textViewer.getDocument();
        return (IHyperlink[])((IXtextDocument)_document).priorityReadOnly((IUnitOfWork)new IUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource resource) throws Exception {
                IParseResult parseResult = resource.getParseResult();
                ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)region.getOffset());
                if (leaf != null && leaf.getSemanticElement() instanceof Import && leaf.getGrammarElement() instanceof RuleCall) {
                    EObject _semanticElement = leaf.getSemanticElement();
                    Resource res = EcoreUtil2.getResource((Resource)resource, (String)((Import)_semanticElement).getImportURI());
                    return (IHyperlink[])Conversions.unwrapArray(CommaHyperLinkDetector.this.createHyperLinksFor((XtextResource)res, leaf, (EObject)res.getContents().get(0)), IHyperlink.class);
                }
                return null;
            }
        });
    }

    public List<XtextHyperlink> createHyperLinksFor(XtextResource from, ILeafNode sourceNode, EObject target) {
        Region _region;
        List<XtextHyperlink> _xblockexpression = null;
        URIConverter uriConverter = from.getResourceSet().getURIConverter();
        URI uri = EcoreUtil.getURI((EObject)target);
        URI _xifexpression = null;
        boolean _isPlatformResource = uri.isPlatformResource();
        _xifexpression = _isPlatformResource ? uri : uriConverter.normalize(uri);
        URI normalized = _xifexpression;
        ITextRegion textRegion = sourceNode.getTextRegion();
        int _offset = textRegion.getOffset();
        int _length = textRegion.getLength();
        Region region = _region = new Region(_offset, _length);
        XtextHyperlink hyperLink = (XtextHyperlink)this.hyperlinkProvider.get();
        hyperLink.setHyperlinkRegion((IRegion)region);
        hyperLink.setURI(normalized);
        hyperLink.setHyperlinkText("Open editor");
        List<Object> _xifexpression_1 = null;
        _xifexpression_1 = hyperLink != null ? Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new XtextHyperlink[]{hyperLink})) : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }
}

