/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.util.ArrayList;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;

public class RequiredExecutionEnvironmentHeader
extends CompositeManifestHeader {
    private static final long serialVersionUID = 1L;

    public RequiredExecutionEnvironmentHeader(String name, String value, IBundle bundle, String lineDelimiter) {
        super(name, value, bundle, lineDelimiter);
    }

    @Override
    protected PDEManifestElement createElement(ManifestElement element) {
        return new ExecutionEnvironment((ManifestHeader)this, element.getValue());
    }

    public boolean hasExecutionEnvironment(IExecutionEnvironment env) {
        return this.hasElement(env.getId());
    }

    public void addExecutionEnvironment(IExecutionEnvironment env) {
        this.addManifestElement(new ExecutionEnvironment((ManifestHeader)this, env.getId()));
    }

    public void addExecutionEnvironment(ExecutionEnvironment environment, int index) {
        this.addManifestElement(environment, index, true);
    }

    public void addExecutionEnvironments(Object[] envs) {
        ArrayList<ExecutionEnvironment> list = new ArrayList<ExecutionEnvironment>(envs.length);
        Object[] objectArray = envs;
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            Object envObject = objectArray[n2];
            ExecutionEnvironment env = null;
            if (envObject instanceof ExecutionEnvironment) {
                env = (ExecutionEnvironment)envObject;
            } else if (envObject instanceof IExecutionEnvironment) {
                env = new ExecutionEnvironment((ManifestHeader)this, ((IExecutionEnvironment)envObject).getId());
            }
            if (env != null && !this.hasElement(env.getName())) {
                list.add(env);
            }
            ++n2;
        }
        if (!list.isEmpty()) {
            this.addManifestElements(list.toArray(new ExecutionEnvironment[list.size()]));
        }
    }

    public void addExecutionEnvironments(ExecutionEnvironment[] envs) {
        this.addManifestElements(envs);
    }

    public ExecutionEnvironment removeExecutionEnvironment(ExecutionEnvironment env) {
        return (ExecutionEnvironment)this.removeManifestElement(env);
    }

    public ExecutionEnvironment removeExecutionEnvironmentUnique(ExecutionEnvironment environment) {
        return (ExecutionEnvironment)this.removeManifestElement(environment, true);
    }

    public ExecutionEnvironment[] getEnvironments() {
        PDEManifestElement[] elements = this.getElements();
        ExecutionEnvironment[] result = new ExecutionEnvironment[elements.length];
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }
}

