/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.impl.InterfaceImpl;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.reachabilitygraph.BuilderDebugLog;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.InputParameters;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;
import org.eclipse.xtext.scoping.IScopeProvider;

class ReachabilityGraphBuilder {
    private final EIState initialState;
    private final InputParameters inputParameters;
    private final ReachabilityGraph graph = new ReachabilityGraph();
    private final int maxDepth;
    private final Set<State> coveredStates = new HashSet<State>();
    private final Set<Clause> coveredClauses = new HashSet<Clause>();
    private final Map<String, Integer> seenEdgeKeys = new HashMap<String, Integer>();
    private final List<Map.Entry<EIState, Integer>> queue = new ArrayList<Map.Entry<EIState, Integer>>();
    public boolean built = false;
    public BuilderDebugLog debugLog = new BuilderDebugLog();

    public ReachabilityGraphBuilder(Interface itf, int maxDepth, List<Parameters> parametersInputSpecification) {
        this.maxDepth = maxDepth;
        this.inputParameters = new InputParameters(parametersInputSpecification);
        this.initialState = new EInterfaceState(itf);
    }

    public ReachabilityGraphBuilder(Component component, int maxDepth, List<Parameters> parametersInputSpecifications, IScopeProvider scopeProvider, List<EConnection> connections) {
        this.maxDepth = maxDepth;
        if (parametersInputSpecifications == null) {
            parametersInputSpecifications = new ArrayList<Parameters>();
        }
        this.inputParameters = new InputParameters(parametersInputSpecifications);
        this.initialState = new EComponentState(component, scopeProvider, connections);
    }

    public ReachabilityGraph build() {
        if (this.built) {
            throw new RuntimeException("Already built");
        }
        this.graph.initial = this.graph.getOrCreateNode(this.getNodeName(this.initialState), ReachabilityGraphBuilder.getStateName(this.initialState), null);
        this.graph.depth = 0;
        this.graph.maxDepth = this.maxDepth;
        this.walkRecursive(this.initialState, 0);
        this.graph.coveredClauses = this.coveredClauses.size();
        this.graph.coveredStates = this.coveredStates.size();
        this.graph.totalClauses = this.initialState.countClauses();
        this.graph.totalStates = this.initialState.countStates();
        this.built = true;
        this.debugLog.setCoveredClauses(this.coveredClauses);
        this.graph.builderDebugLog = this.debugLog;
        return this.graph;
    }

    private static String getStateName(EIState state) {
        return String.join((CharSequence)"_", state.getCurrentStates().stream().map(s -> s.getName()).collect(Collectors.toList()));
    }

    private static String variableToString(EVariable variable) {
        if (variable.value == null) {
            return "null";
        }
        if (variable.type == EVariableType.VECTOR) {
            String value = variable.getValueVector().stream().map(v -> ReachabilityGraphBuilder.variableToString(v)).collect(Collectors.joining("_"));
            return String.format("[%s]", value);
        }
        if (variable.type == EVariableType.RECORD) {
            String value = variable.getValueRecord().entrySet().stream().map(e -> String.format("%s_%s", e.getKey(), ReachabilityGraphBuilder.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        if (variable.type == EVariableType.MAP) {
            String value = variable.getValueMap().entrySet().stream().map(e -> String.format("%s_%s", ReachabilityGraphBuilder.variableToString((EVariable)e.getKey()), ReachabilityGraphBuilder.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        return variable.value.toString();
    }

    private String getNodeName(EIState state) {
        Function<EInterfaceState, String> getNodeNameInterfaceState = s -> {
            String name = ReachabilityGraphBuilder.getStateName((EIState)s);
            EVariableCollection variables = s.getVariables();
            for (String variableName : variables.allNamesSorted()) {
                name = String.valueOf(name) + "_" + ReachabilityGraphBuilder.variableToString(variables.get(variableName));
            }
            if (s.transition != null) {
                name = s.transition.transition instanceof TriggeredTransition ? String.valueOf(name) + "_Triggered_" + ((TriggeredTransition)s.transition.transition).getTrigger().getName() : String.valueOf(name) + "_NonTriggered";
            }
            return name;
        };
        if (state instanceof EComponentState) {
            return String.join((CharSequence)"__", ((EComponentState)state).connections.entrySet().stream().map(e -> String.format("%s_%s_%s", ((EConnection)e.getKey()).port, ((EConnection)e.getKey()).id, getNodeNameInterfaceState.apply((EInterfaceState)e.getValue()))).collect(Collectors.toList()));
        }
        return getNodeNameInterfaceState.apply((EInterfaceState)state);
    }

    private static String getStartToIntermediateEdgeKey(String startNode, String intermediateNode, int transitionIndex, ETransition transition, EClause clause) {
        String connection = transition.connection == null ? "" : String.format("%s_%s", transition.connection.port, transition.connection.id);
        return String.format("%s_%s_%s_%d_%d", connection, startNode, intermediateNode, transitionIndex, transition.transition.getClauses().indexOf((Object)clause.clause));
    }

    private List<EVariableCollection> getParameters(ETransition transition) {
        TriggeredTransition t;
        String itf;
        List<EVariableCollection> parameters = new ArrayList<EVariableCollection>();
        if (transition.transition instanceof TriggeredTransition && this.inputParameters.hasParametersSet(itf = ((InterfaceImpl)transition.machine.eContainer()).getName(), (t = (TriggeredTransition)transition.transition).getTrigger().getName(), transition.state.getName())) {
            parameters = this.inputParameters.getParametersSet(itf, t.getTrigger().getName(), transition.state.getName());
        }
        if (parameters.isEmpty()) {
            parameters.add(new EVariableCollection());
        }
        return parameters;
    }

    public String debugTransitionToString(ETransition transition, EVariableCollection parameters) {
        String name;
        String string = name = transition.connection == null ? "" : String.format("%s_%s", transition.connection.port, transition.connection.id);
        if (transition.transition instanceof TriggeredTransition) {
            name = String.valueOf(name) + "_Triggered_" + ((TriggeredTransition)transition.transition).getTrigger().getName();
            name = String.valueOf(name) + ", parameters: ";
            name = String.valueOf(name) + String.join((CharSequence)", ", parameters.allNamesSorted().stream().map(p -> String.valueOf(p) + ":" + eVariableCollection.get((String)p).value.toString()).collect(Collectors.toList()));
        } else {
            name = String.valueOf(name) + "_NonTriggered";
        }
        return name;
    }

    public void walkRecursive(EIState startState, int depth) {
        if (depth > this.maxDepth) {
            return;
        }
        if (this.graph.depth < depth) {
            this.graph.depth = depth;
        }
        this.coveredStates.addAll(startState.getCurrentStates());
        Node startNode = this.graph.getOrCreateNode(this.getNodeName(startState), ReachabilityGraphBuilder.getStateName(startState), null);
        this.debugLog.add(depth * 3, "S:" + startNode.name + ", depth: " + depth);
        List transitions = startState.possibleTransitions();
        if (transitions.isEmpty()) {
            this.debugLog.appendToLast(" => Done, no transitions possible");
        }
        for (ETransition transition : transitions) {
            for (EVariableCollection parameters : this.getParameters(transition)) {
                this.debugLog.add(1 + depth * 3, "T:" + this.debugTransitionToString(transition, parameters));
                EIState intermediateState = startState.takeTransition(transition, parameters);
                List clauses = intermediateState.possibleClauses();
                if (clauses.isEmpty()) {
                    this.debugLog.appendToLast(" => Done, no clauses possible");
                }
                for (EClause clause : clauses) {
                    this.debugLog.add(2 + depth * 3, "C:" + this.debugLog.clauseID(clause.clause));
                    this.coveredClauses.add(clause.clause);
                    EIState endState = intermediateState.takeClause(clause);
                    String intermediateName = this.getNodeName(intermediateState);
                    String edgeKey = ReachabilityGraphBuilder.getStartToIntermediateEdgeKey(startNode.name, intermediateName, transitions.indexOf(transition), transition, clause);
                    if (!this.seenEdgeKeys.containsKey(edgeKey)) {
                        this.seenEdgeKeys.put(edgeKey, depth);
                        this.debugLog.appendToLast(String.format(" => Edge key '%s', adding to graph", edgeKey));
                        if (depth + 1 > this.maxDepth) {
                            this.debugLog.appendToLast(", done, max depth reached");
                        }
                        Node endNode = this.graph.getOrCreateNode(this.getNodeName(endState), ReachabilityGraphBuilder.getStateName(endState), null);
                        if (!intermediateState.getActions().isEmpty()) {
                            Object trigger = intermediateState.getActions().get(0);
                            String triggerName = trigger instanceof ECommand ? ((ECommand)trigger).method : ((ESignal)trigger).method;
                            Node intermediateNode = this.graph.getOrCreateNode(intermediateName, startNode.state, triggerName);
                            Optional<Edge> startToIntermediate = this.graph.getEdge(startNode, intermediateNode);
                            if (!startToIntermediate.isPresent()) {
                                this.graph.createEdge((Node)startNode, (Node)intermediateNode).entries = intermediateState.getActions();
                            }
                            Edge intermediateToEnd = this.graph.createEdge(intermediateNode, endNode);
                            intermediateToEnd.entries = endState.getActions();
                        } else {
                            Edge startToEnd = this.graph.createEdge(startNode, endNode);
                            startToEnd.entries = endState.getActions();
                        }
                        this.queue.add(Map.entry(endState, depth + 1));
                        continue;
                    }
                    this.debugLog.appendToLast(String.format(" => Done, edge key '%s' already found", edgeKey));
                }
            }
        }
        if (depth == 0) {
            while (!this.queue.isEmpty()) {
                Map.Entry<EIState, Integer> next = this.queue.remove(0);
                this.walkRecursive(next.getKey(), next.getValue());
            }
        }
    }
}

