/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.diagnostic.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.diagnostic.AbstractDiagnosticData;
import org.eclipse.corona.internal.diagnostic.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class LogDiagnosticData
extends AbstractDiagnosticData
implements Serializable,
LogListener {
    private static final String LOG_READER_SERVICE = "LogReaderService";
    private LogService logService = Activator.getDefault().getLogService();
    private static final long serialVersionUID = 1L;
    private transient BundleContext ctxBundle;
    private transient ServiceRegistration srvRegEventHandler;
    private transient int qSize = 200;
    private transient LogEntry[] qTempData;
    private transient int qTempHead = 0;
    private transient int qTempTail = 0;
    private LogEntry[] qCaptureData;
    private transient int qCaptureHead = 0;
    private transient int qCaptureTail = 0;
    private ServiceReference refLogReaderService;
    private static final String ATTR_QSIZE = "qsize";

    protected void activate(ComponentContext componentContext) {
        String string;
        this.ctxBundle = componentContext.getBundleContext();
        super.initComponent(componentContext.getProperties());
        Object v = componentContext.getProperties().get(ATTR_QSIZE);
        if (v instanceof String[] && (string = ((String[])v)[0]) != null) {
            this.qSize = Integer.parseInt(string);
        }
        this.qTempData = new LogEntry[this.qSize];
        string = (LogReaderService)componentContext.locateService(LOG_READER_SERVICE);
        if (string != null) {
            string.addLogListener((LogListener)this);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.ctxBundle.ungetService(this.refLogReaderService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture() {
        LogEntry[] logEntryArray = this.qTempData;
        synchronized (this.qTempData) {
            this.qCaptureData = this.qTempData;
            this.qCaptureHead = this.qTempHead;
            this.qCaptureTail = this.qTempTail;
            this.qTempData = new LogEntry[this.qSize];
            this.qTempHead = 0;
            this.qTempTail = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.createXML();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        super.save(outputStream);
        this.cleanUp();
    }

    private int qCaptureSize() {
        int n = 0;
        n = this.qTempHead > this.qTempTail ? this.qTempHead - this.qTempTail : this.qSize - this.qTempHead + this.qTempTail;
        return n;
    }

    private void createXML() throws ParserConfigurationException {
        super.initXmlDocument();
        Element element = super.createElementDiagnostic();
        int n = this.qCaptureHead >= this.qCaptureTail ? this.qCaptureHead - this.qCaptureTail : this.qSize - this.qCaptureHead + this.qCaptureTail - 1;
        this.logService.log(4, "...diagnostic event capture count:" + n);
        element.setAttribute("count", Integer.toString(n));
        int n2 = 0;
        while (n2 < n) {
            LogEntry logEntry = this.qCaptureData[n2];
            Element element2 = this.docDiag.createElement("LogEntry");
            element2.setAttribute("level", Integer.toString(logEntry.getLevel()));
            element2.setAttribute("timestamp", Long.toString(logEntry.getTime()));
            element2.setAttribute("bundle", logEntry.getBundle().getSymbolicName());
            Text text = this.docDiag.createTextNode(logEntry.getMessage());
            element2.appendChild(text);
            element.appendChild(element2);
            Throwable throwable = logEntry.getException();
            if (throwable != null) {
                Element element3 = this.docDiag.createElement("Exception");
                element3.setAttribute("message", throwable.getMessage());
                StringBuffer stringBuffer = new StringBuffer();
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n3 = 0;
                while (n3 < stackTraceElementArray.length) {
                    stringBuffer.append(String.valueOf(stackTraceElementArray[n2].toString()) + "\n");
                    ++n3;
                }
                Text text2 = this.docDiag.createTextNode(stringBuffer.toString());
                element3.appendChild(text2);
                element2.appendChild(element3);
            }
            ++n2;
        }
        this.rootDiag.appendChild(element);
    }

    public String getType() {
        return "xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logged(LogEntry logEntry) {
        LogEntry[] logEntryArray = this.qTempData;
        synchronized (this.qTempData) {
            this.qTempData[this.qTempHead++] = logEntry;
            this.qTempHead %= this.qSize;
            if (this.qTempHead == this.qTempTail) {
                ++this.qTempTail;
                this.qTempTail %= this.qSize;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

