/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.FactoryReg;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.ServiceReg;
import org.eclipse.equinox.internal.ds.impl.ComponentFactoryImpl;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class InstanceProcess {
    public static Resolver resolver;
    public static InstanceProcess staticRef;
    protected Hashtable factoryRegistrations;
    private Vector delayedBindList;
    static Hashtable buildingThreads;
    static Hashtable stackCounts;
    static int waitTime;
    boolean busyBuilding = false;
    Thread workingThread;
    Object lock = new Object();
    int lockCounter = 0;
    static /* synthetic */ Class class$0;

    static {
        buildingThreads = new Hashtable(7);
        stackCounts = new Hashtable(7);
        waitTime = Activator.getInteger("equinox.scr.waitTimeOnBlock", 10000);
    }

    InstanceProcess(Resolver resolver) {
        InstanceProcess.resolver = resolver;
        this.factoryRegistrations = new Hashtable(19);
        this.delayedBindList = new Vector(10);
        staticRef = this;
    }

    void dispose() {
        this.factoryRegistrations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLock() {
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (!this.busyBuilding) {
                this.busyBuilding = true;
                ++this.lockCounter;
                this.workingThread = currentThread;
            } else if (this.workingThread == currentThread) {
                ++this.lockCounter;
            } else if (this.workingThread != currentThread) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                boolean lockSucceeded = false;
                do {
                    try {
                        this.lock.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.busyBuilding) continue;
                    this.busyBuilding = true;
                    ++this.lockCounter;
                    this.workingThread = currentThread;
                    lockSucceeded = true;
                    break;
                } while ((timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (!lockSucceeded) {
                    Activator.log.warning("Getting a lock required more than " + waitTime + " ms. There might be a synchronization problem in this callstack " + "or just the build/dispose process of some components took too long!", (Throwable)new Exception("Debug stacktrace"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.busyBuilding) {
                if (this.workingThread == Thread.currentThread()) {
                    --this.lockCounter;
                }
                if (this.lockCounter == 0) {
                    this.busyBuilding = false;
                    this.workingThread = null;
                    this.lock.notify();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void buildComponents(Vector list, boolean security) {
        scp = null;
        factoryPid = null;
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                block28: {
                    scp = (ServiceComponentProp)list.elementAt(i);
                    this.getLock();
                    componentState = scp.getState();
                    if (componentState <= 1 || componentState > 2) {
                        this.freeLock();
                    } else {
                        block26: {
                            block27: {
                                start = 0L;
                                successfullyBuilt = true;
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info("[DS perf] Start building component " + scp);
                                }
                                scp.setState(3);
                                sc = scp.serviceComponent;
                                if (sc.immediate) {
                                    if (Activator.DEBUG) {
                                        Activator.log.debug(0, 10003, scp.name, null, false);
                                    }
                                    if (sc.serviceInterfaces != null) {
                                        this.registerService(scp, sc.serviceFactory, null);
                                    }
                                    if (!scp.instances.isEmpty()) break block26;
                                    try {
                                        this.buildComponent(null, scp, null, security);
                                    }
                                    catch (Exception e) {
                                        if (!(e instanceof ComponentException)) {
                                            Activator.log.error("[SCR] Cannot build component " + scp, (Throwable)e);
                                        }
                                        break block26;
                                    }
                                }
                                if (sc.factory == null || !scp.isComponentFactory()) break block27;
                                if (Activator.DEBUG) {
                                    Activator.log.debug(0, 10004, scp.name, null, false);
                                }
                                try {
                                    config = ConfigurationManager.getConfiguration(sc.name);
                                    if (config != null) {
                                        factoryPid = config.getFactoryPid();
                                    }
                                }
                                catch (Exception e) {
                                    Activator.log.error("[SCR] Cannot get configuration for component " + sc.name, (Throwable)e);
                                }
                                if (factoryPid != null) {
                                    toDisable = new Vector<ServiceComponent>(1);
                                    toDisable.addElement(sc);
                                    InstanceProcess.resolver.disableComponents(toDisable);
                                    successfullyBuilt = false;
                                    throw new ComponentException("ManagedServiceFactory and ComponentFactory are incompatible");
                                }
                                this.registerComponentFactory(scp);
                                scp.setState(successfullyBuilt != false ? 4 : 0);
                                this.freeLock();
                                ** if (!Activator.PERF) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is built for " + start + " ms");
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block28;
                                }
                            }
                            try {
                                try {
                                    if (sc.provides != null) {
                                        this.registerService(scp, sc.serviceFactory, null);
                                    }
                                }
                                catch (Throwable t) {
                                    Activator.log.error("[SCR] Exception occurred while building component configuration of component " + scp.serviceComponent, t);
                                    scp.setState(successfullyBuilt != false ? 4 : 0);
                                    this.freeLock();
                                    if (Activator.PERF) {
                                        start = System.currentTimeMillis() - start;
                                        Activator.log.info("[DS perf] The component " + scp + " is built for " + start + " ms");
                                    }
                                    break block28;
                                }
                            }
                            catch (Throwable var12_14) {
                                scp.setState(successfullyBuilt != false ? 4 : 0);
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is built for " + start + " ms");
                                }
                                throw var12_14;
                            }
                        }
                        scp.setState(successfullyBuilt != false ? 4 : 0);
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info("[DS perf] The component " + scp + " is built for " + start + " ms");
                        }
                    }
                }
                ++i;
            }
        }
    }

    void disposeInstances(Vector scpList) {
        if (scpList != null) {
            int i = 0;
            while (i < scpList.size()) {
                block13: {
                    ServiceComponentProp scp = (ServiceComponentProp)scpList.elementAt(i);
                    this.getLock();
                    if (scp.getState() <= 1) {
                        this.freeLock();
                    } else {
                        long start = 0L;
                        try {
                            try {
                                scp.setState(1);
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info("[DS perf] Start disposing component " + scp);
                                }
                                this.disposeInstances(scp);
                            }
                            catch (Throwable t) {
                                Activator.log.error("Exception while disposing instances of component " + scp, t);
                                resolver.componentDisposed(scp);
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info("[DS perf] The component " + scp + " is disposed for " + start + " ms");
                                }
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            resolver.componentDisposed(scp);
                            this.freeLock();
                            if (Activator.PERF) {
                                start = System.currentTimeMillis() - start;
                                Activator.log.info("[DS perf] The component " + scp + " is disposed for " + start + " ms");
                            }
                            throw throwable;
                        }
                        resolver.componentDisposed(scp);
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info("[DS perf] The component " + scp + " is disposed for " + start + " ms");
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void disposeInstances(ServiceComponentProp scp) {
        ServiceComponent sc = scp.serviceComponent;
        if (sc.provides == null) {
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10006, scp.name, null, false);
            }
            scp.dispose();
        } else {
            ServiceRegistration reg;
            if (scp.isComponentFactory()) {
                if (Activator.DEBUG) {
                    Activator.log.debug(0, 10007, scp.name, null, false);
                }
                reg = (ServiceRegistration)this.factoryRegistrations.remove(scp);
                try {
                    if (reg != null) {
                        reg.unregister();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    Activator.log.warning("InstanceProcess.disposeInstances(): registration for component factory " + scp.name + " is already diposed!", null);
                }
            }
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10008, scp.name, null, false);
            }
            if (scp.registration != null) {
                try {
                    reg = scp.registration;
                    scp.setRegistration(null);
                    reg.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    Activator.log.warning("InstanceProcess.disposeInstances(): registration for component " + scp.name + " is already diposed!", null);
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug(0, 10009, scp.name, null, false);
            }
            scp.dispose();
        }
    }

    private void registerComponentFactory(ServiceComponentProp scp) {
        if (this.factoryRegistrations.get(scp) != null) {
            return;
        }
        ComponentFactoryImpl factory = new ComponentFactoryImpl(scp);
        ServiceComponent sc = scp.serviceComponent;
        BundleContext bc = scp.bc;
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("component.name", sc.name);
        properties.put("component.factory", sc.factory);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = bc.registerService(clazz.getName(), (Object)factory, properties);
        this.factoryRegistrations.put(scp, reg);
    }

    final void dynamicBind(Vector refList) {
        if (refList == null || refList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < refList.size()) {
            Reference ref = (Reference)refList.elementAt(i);
            ServiceComponentProp scp = ref.scp;
            Vector instances = scp.instances;
            if (instances != null) {
                int j = 0;
                while (j < instances.size()) {
                    ComponentInstance compInstance = (ComponentInstance)instances.elementAt(j);
                    if (compInstance != null) {
                        try {
                            scp.bindReference(ref, compInstance);
                        }
                        catch (Exception exception) {}
                    }
                    ++j;
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug(0, 10012, scp.name, null, false);
            }
            ++i;
        }
    }

    final void dynamicUnBind(Hashtable serviceTable) {
        try {
            if (serviceTable == null || serviceTable.isEmpty()) {
                return;
            }
            Enumeration e = serviceTable.keys();
            while (e.hasMoreElements()) {
                Reference ref = (Reference)e.nextElement();
                Hashtable serviceSubTable = (Hashtable)serviceTable.get(ref);
                Enumeration sub = serviceSubTable.keys();
                while (sub.hasMoreElements()) {
                    ServiceComponentProp scp = (ServiceComponentProp)sub.nextElement();
                    ServiceReference serviceReference = (ServiceReference)serviceSubTable.get(scp);
                    Vector instances = scp.instances;
                    int i = 0;
                    while (i < instances.size()) {
                        ComponentInstance compInstance = (ComponentInstance)instances.elementAt(i);
                        if (compInstance != null) {
                            try {
                                scp.unbindDynamicReference(ref, compInstance, serviceReference);
                            }
                            catch (Throwable t) {
                                Activator.log.error("[SCR] Error while dynamically unbinding reference '" + ref.reference + "' of component instance " + compInstance.getInstance(), t);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected error!", e);
        }
    }

    private void registerService(ServiceComponentProp scp, boolean factory, ComponentInstanceImpl ci) {
        ServiceRegistration reg = null;
        if (scp.registration != null) {
            return;
        }
        Object service = factory ? new FactoryReg(scp) : new ServiceReg(scp, ci);
        reg = scp.bc.registerService(scp.serviceComponent.provides, service, (Dictionary)scp.getProperties());
        if (Activator.DEBUG) {
            Activator.log.debug("InstanceProcess.registerService(): " + scp.name + " registered as " + (factory ? "*factory*" : "*service*"), null);
        }
        if (scp.getState() <= 1) {
            try {
                reg.unregister();
                if (Activator.DEBUG) {
                    Activator.log.debug("InstanceProcess.registerService(): " + scp.name + "'s service was unregistered because the component is already disposed!", null);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            scp.setRegistration(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstanceImpl buildComponent(Bundle usingBundle, ServiceComponentProp scp, Object instance, boolean security) throws ComponentException {
        ServiceComponentProp serviceComponentProp;
        ComponentInstanceImpl componentInstanceImpl;
        Counter counter;
        if (Activator.DEBUG) {
            Activator.log.debug(0, 10005, scp.name, null, false);
        }
        this.getLock();
        Thread curThread = Thread.currentThread();
        ServiceComponentProp serviceComponentProp2 = scp;
        synchronized (serviceComponentProp2) {
            Thread theSCPThread = (Thread)buildingThreads.get(scp);
            if (theSCPThread != null && curThread != theSCPThread && !scp.isKindOfFactory()) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                do {
                    try {
                        scp.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (buildingThreads.get(scp) != null && (timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (buildingThreads.get(scp) != null) {
                    this.freeLock();
                    if (!scp.instances.isEmpty()) {
                        Activator.log.warning("Returning SCP instance which is not fully activated!", (Throwable)new Exception("Debug callstack"));
                        return (ComponentInstanceImpl)scp.instances.firstElement();
                    }
                    throw new RuntimeException("The instance creation of component " + scp + " took longer than " + waitTime + " ms. There might be a synchronization problem in this callstack or just the instance creation took too long!");
                }
            }
            buildingThreads.put(scp, curThread);
            counter = (Counter)stackCounts.get(curThread);
            if (counter == null) {
                counter = new Counter();
                stackCounts.put(curThread, counter);
            }
            ++counter.count;
        }
        long start = 0L;
        try {
            if (Activator.PERF) {
                start = System.currentTimeMillis();
                Activator.log.info("[DS perf] Start building instance of component " + scp);
            }
            ComponentInstanceImpl componentInstance = null;
            try {
                try {
                    componentInstance = scp.build(usingBundle, instance, security);
                }
                catch (ComponentException e) {
                    Activator.log.error(e.getMessage(), e.getCause());
                    throw e;
                }
                catch (Throwable t) {
                    Activator.log.error("[SCR] Error while building configuration of component " + scp.serviceComponent, t);
                    throw new ComponentException("Error while building configuration of component " + scp.serviceComponent, t);
                }
            }
            finally {
                --counter.count;
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info("[DS perf] The instance of component " + scp + " is built for " + start + " ms");
                }
            }
            if (counter.count == 0 && !this.delayedBindList.isEmpty()) {
                InstanceProcess.resolver.mgr.enqueueWork(resolver, 2, this.delayedBindList.clone(), security);
                this.delayedBindList.removeAllElements();
            }
            componentInstanceImpl = componentInstance;
            serviceComponentProp = scp;
        }
        catch (Throwable throwable) {
            ServiceComponentProp serviceComponentProp3 = scp;
            synchronized (serviceComponentProp3) {
                if (counter.count == 0) {
                    stackCounts.remove(curThread);
                }
                buildingThreads.remove(scp);
                scp.notify();
            }
            this.freeLock();
            throw throwable;
        }
        synchronized (serviceComponentProp) {
            if (counter.count == 0) {
                stackCounts.remove(curThread);
            }
            buildingThreads.remove(scp);
            scp.notify();
        }
        this.freeLock();
        return componentInstanceImpl;
    }

    public Object getService(Reference reference, ServiceReference serviceReference) {
        if (this.checkCanCauseCycle(reference, serviceReference)) {
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10010, String.valueOf(reference.reference.name) + " ; The service reference is " + serviceReference, null, false);
            }
            return null;
        }
        return reference.scp.bc.getService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCanCauseCycle(Reference reference, ServiceReference serviceReference) {
        int i;
        ServiceComponentProp consumerSCP = reference.scp;
        if (buildingThreads.isEmpty()) {
            return false;
        }
        String producerComponentName = (String)serviceReference.getProperty("component.name");
        if (producerComponentName == null) {
            return false;
        }
        if (consumerSCP.getDelayActivateSCPNames() == null || !consumerSCP.getDelayActivateSCPNames().contains(producerComponentName)) {
            return false;
        }
        ServiceComponentProp producerSCP = null;
        Vector vector = InstanceProcess.resolver.satisfiedSCPs;
        synchronized (vector) {
            i = 0;
            while (i < InstanceProcess.resolver.satisfiedSCPs.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)InstanceProcess.resolver.satisfiedSCPs.elementAt(i);
                if (producerComponentName.equals(scp.serviceComponent.name)) {
                    producerSCP = scp;
                    break;
                }
                ++i;
            }
        }
        if (producerSCP != null) {
            if (producerSCP.serviceComponent.serviceFactory) {
                if (!producerSCP.instances.isEmpty()) {
                    Bundle bundle = consumerSCP.bc.getBundle();
                    i = 0;
                    while (i < producerSCP.instances.size()) {
                        ComponentInstanceImpl producerComponentInstance = (ComponentInstanceImpl)producerSCP.instances.elementAt(i);
                        if (producerComponentInstance.getComponentContext().getUsingBundle().equals(bundle)) {
                            return false;
                        }
                        ++i;
                    }
                }
            } else if (!producerSCP.instances.isEmpty()) {
                return false;
            }
        }
        if (reference.reference.bind != null && reference.policy == 1) {
            this.delayedBindList.addElement(reference);
        }
        return true;
    }

    class Counter {
        int count = 0;

        Counter() {
        }
    }
}

