/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.equinox.internal.util.ref.Log;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
implements ComponentFactory {
    static boolean security = false;
    private ServiceComponentProp sci;

    public ComponentFactoryImpl(ServiceComponentProp component) {
        security = Log.security();
        this.sci = component;
    }

    public ComponentInstance newInstance(Dictionary additionalProps) {
        ComponentInstanceImpl instance = null;
        try {
            if (Activator.DEBUG) {
                Activator.log.debug(0, 10032, this.sci.name, null, false);
            }
            Hashtable props = (Hashtable)this.sci.getProperties().clone();
            SCRUtil.copyTo(props, additionalProps);
            ServiceComponentProp newSCP = InstanceProcess.resolver.mapNewFactoryComponent(this.sci.serviceComponent, props);
            Vector<ServiceComponentProp> toBuild = new Vector<ServiceComponentProp>(1);
            toBuild.addElement(newSCP);
            InstanceProcess.staticRef.buildComponents(toBuild, security);
            if (!newSCP.instances.isEmpty()) {
                instance = (ComponentInstanceImpl)newSCP.instances.firstElement();
            }
            if (instance == null) {
                instance = InstanceProcess.staticRef.buildComponent(null, newSCP, null, security);
            }
            instance.factory = this;
        }
        catch (Throwable e) {
            if (e instanceof ComponentException) {
                throw (ComponentException)e;
            }
            Activator.log.error("ComponentFactoryImpl.newInstance(): failed for " + this.sci.name + " with properties " + additionalProps, e);
            throw new ComponentException("Failed to create new instance", e);
        }
        return instance;
    }

    public String toString() {
        return "ComponentFactory for " + this.sci.name;
    }
}

