/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.server;

import java.io.File;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.corona.internal.Activator;
import org.eclipse.corona.server.IServerApplication;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public abstract class AbstractServerApplication
implements IServerApplication {
    private LogService logService = Activator.getDefault().getLogService();
    private static final String WORKING_DIR = "working.dir";
    protected String name;
    private String[] args;
    private Properties properties = new Properties();
    protected File workingDir;
    private ThreadGroup threadGroup;
    private ServiceRegistration srvRegistration;
    private BundleContext ctxBundle;

    public Object start(BundleContext bundleContext, IApplicationContext iApplicationContext, String string) throws Exception {
        this.ctxBundle = bundleContext;
        Integer n = IApplication.EXIT_OK;
        this.setName(string);
        Map map = iApplicationContext.getArguments();
        this.args = map != null ? (String[])map.get("application.args") : new String[0];
        this.initProperties();
        this.initialize();
        this.srvRegistration = bundleContext.registerService(IServerApplication.class.getName(), (Object)this, (Dictionary)this.properties);
        return n;
    }

    public void stop() {
        this.srvRegistration.unregister();
    }

    private void initProperties() {
        int n = 0;
        while (n < this.args.length) {
            String string = this.args[n];
            if (string.contains("=")) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    this.properties.setProperty(string2, string3);
                }
                catch (Exception exception) {
                    this.logService.log(2, "invalid argument property: " + string);
                }
            }
            ++n;
        }
    }

    protected void initialize() {
        this.threadGroup = new ThreadGroup(this.getName());
        this.initWorkingDir();
    }

    protected void initWorkingDir() {
        String string = this.getProperty(WORKING_DIR);
        if (string == null) {
            this.logService.log(3, "defaulting application working.dir to workspace");
            String string2 = System.getProperty("osgi.instance.area.default");
            if (string2 != null) {
                File file = new File(string2);
                File file2 = new File(file, this.getName());
                string = file2.getAbsolutePath();
            } else {
                this.logService.log(2, "workspace is NOT defined.  unable to set application's working.dir");
            }
        }
        if (string != null) {
            this.workingDir = new File(string);
            if (!this.workingDir.exists()) {
                this.workingDir.mkdirs();
            }
        }
    }

    protected String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    protected void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.properties.setProperty("name", string);
    }

    public File getWorkingDirectory() {
        if (this.workingDir == null) {
            this.logService.log(2, "component server application not properly configured...");
            this.logService.log(2, "...application working.dir is NOT defined, attempting to using 'java.io.tmpdir'");
            File file = new File(System.getProperty("java.io.tmpdir"));
            this.workingDir = new File(file, this.getName());
            if (!this.workingDir.exists()) {
                this.workingDir.mkdirs();
            }
        }
        return this.workingDir;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable);
        return thread;
    }

    protected void startBundles(String[] stringArray) {
        Bundle[] bundleArray = this.ctxBundle.getBundles();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            boolean bl = false;
            int n2 = 0;
            while (n2 < bundleArray.length) {
                String string2 = bundleArray[n2].getSymbolicName();
                if (string2.equals(string)) {
                    bl = true;
                    try {
                        if (bundleArray[n2].getState() == 4) {
                            this.logService.log(3, "application.startBundles(): " + string2);
                            bundleArray[n2].start();
                        }
                    }
                    catch (BundleException bundleException) {
                        this.logService.log(2, "application.startBundles(): " + string2, (Throwable)bundleException);
                    }
                }
                ++n2;
            }
            if (!bl) {
                this.logService.log(2, "Cound NOT start bundle - not found: " + string);
            }
            ++n;
        }
    }

    protected void stopBundles(String[] stringArray) {
        Bundle[] bundleArray = this.ctxBundle.getBundles();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < bundleArray.length) {
                String string = bundleArray[n2].getSymbolicName();
                if (string.equals(stringArray[n])) {
                    try {
                        if (bundleArray[n2].getState() == 32) {
                            this.logService.log(3, "application.stopBundles(): " + string);
                            bundleArray[n2].stop();
                        }
                    }
                    catch (BundleException bundleException) {
                        this.logService.log(2, "application.stopBundles(): " + string, (Throwable)bundleException);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }
}

