/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class CoronaPlugin
extends Plugin
implements LogService {
    protected final String PLUGIN_ID;
    private BundleContext ctxBundle;
    protected LogService logService;
    private static final String LOG_ERROR = " [ERROR] ";
    private static final String LOG_WARNING = " [WARNING] ";
    private static final String LOG_INFO = " [INFO] ";
    private static final String LOG_DEBUG = " [DEBUG] ";
    protected ServiceTracker logServiceTracker;

    public CoronaPlugin(String string) {
        this.PLUGIN_ID = string;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.ctxBundle = bundleContext;
        this.logServiceTracker = new ServiceTracker(bundleContext, LogService.class.getName(), null);
        this.logServiceTracker.open();
        this.logService = (LogService)this.logServiceTracker.getService();
        this.log(3, "Starting: " + this.PLUGIN_ID);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.log(3, "Stopping: " + this.PLUGIN_ID);
        this.logServiceTracker.close();
        super.stop(bundleContext);
        this.ctxBundle = null;
        this.logService = null;
    }

    public LogService getLogService() {
        return this;
    }

    public void log(int n, String string, Throwable throwable) {
        if (this.logService != null && (n != 4 || this.isDebugging())) {
            this.logService.log(n, string, throwable);
        }
        if (this.isDebugging()) {
            this.logDebugging(n, string, throwable);
        }
    }

    public BundleContext getBundleContext() {
        return this.ctxBundle;
    }

    public void log(int n, String string) {
        if (this.logService != null && (n != 4 || this.isDebugging())) {
            this.logService.log(n, string);
        }
        if (this.isDebugging()) {
            this.logDebugging(n, string, null);
        }
    }

    public void log(ServiceReference serviceReference, int n, String string, Throwable throwable) {
        if (this.logService != null && (n != 4 || this.isDebugging())) {
            this.logService.log(serviceReference, n, string, throwable);
        }
        if (this.isDebugging()) {
            this.logDebugging(n, string, throwable);
        }
    }

    public void log(ServiceReference serviceReference, int n, String string) {
        if (this.logService != null && (n != 4 || this.isDebugging())) {
            this.logService.log(serviceReference, n, string);
        }
        if (this.isDebugging()) {
            this.logDebugging(n, string, null);
        }
    }

    private void logDebugging(int n, String string, Throwable throwable) {
        System.out.println(String.valueOf(this.PLUGIN_ID) + this.logLevel(n) + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    private String logLevel(int n) {
        String string = "UNKNOWN";
        if ((n & 4) != 0) {
            string = LOG_DEBUG;
        } else if ((n & 3) != 0) {
            string = LOG_INFO;
        } else if ((n & 2) != 0) {
            string = LOG_WARNING;
        } else if ((n & 1) != 0) {
            string = LOG_ERROR;
        }
        return string;
    }
}

