@echo off
rem *****************************************************************
rem * Copyright (c) 2007-2008 Compuware Corporation and others.
rem * 
rem * All rights reserved. This program and the accompanying 
rem * materials are made available under the terms of the 
rem * Eclipse Public License v1.0 which accompanies this 
rem * distribution, and is available at:
rem * http://www.eclipse.org/legal/epl-v10.html 
rem * 
rem * Contributors:
rem *     Compuware Corporation - initial API and implementation
rem *****************************************************************
setlocal
cls
echo Corona - Eclipse Tool Services Framework
echo.

REM jvm used to run the build.  Defaults to java on system path
set jvm=java

REM ****************************************************************
REM * Identify the Eclipse Equinox launcher to use
REM ****************************************************************
for %%f in (plugins\org.eclipse.equinox.launcher_*.jar) do set launcher=%%f
echo ...using Eclipse launcher: "%launcher%"
if "%launcher%"=="" goto errLauncher

if "%1"=="run" goto run
if "%1"=="test" goto test
if "%1"=="install" goto install
if "%1"=="setup" goto setup

goto help

REM ****************************************************************
REM * Corona Server
REM ****************************************************************
:run
echo * Starting the Corona server application
%jvm% -jar %launcher% -console -clean -application org.eclipse.corona.application 
goto :EOF

REM ****************************************************************
REM * Corona Test Framework
REM ****************************************************************
:test
for %%f in (plugins\org.eclipse.corona.test_*.jar) do set coronaTest=%%f
if "%coronaTest%"=="" goto errCoronaTest

echo * Starting the Corona test framework application
%jvm% -Dosgi.noShutdown=true -jar %launcher% -console -clean -application org.eclipse.corona.test.application 
goto :EOF

REM ****************************************************************
REM * Install feature
REM ****************************************************************
:install
set updateSite=%2
if "%updateSite%"=="" goto errInstall
set featureId=%3
if "%featureId%"=="" goto errInstall
set featureVersion=%4
if "%featureVersion%"=="" goto errInstall

echo * Installing feature into the Corona environment
%jvm% -jar %launcher% -console -application org.eclipse.update.core.standaloneUpdate -command install -from %updateSite% -featureId %featureId% -version %featureVersion% 

goto :EOF

:setup
echo not yet implemented
goto :EOF

:help
echo ERROR: invalid command line syntax
echo *   corona [options] ^<cmd^> [args]
echo *
echo *	^<cmd^>
echo *		run     - run the Corona server application
echo *		test    - run the Corona test framework application
echo *		install - install a feature into Corona
echo *			^<UpdateSite^> ^<FeatureId^> ^<FeatureVersion^>
echo *
goto :EOF

:errLauncher
echo.
echo ERROR: Eclipse Equinox Launcher
echo * Could not identify the launcher to use
goto :EOF

:errCoronaTest
echo.
echo ERROR: Corona Test Framework
echo * Could not find the Corona test framework
goto :EOF

:errInstall
echo.
echo ERROR: Could NOT install feature
echo * Invalid command line syntax
goto help

