/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.generic.DestroyIterator;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOWrapper;
import org.eclipse.ecf.provider.generic.gmm.GMMImpl;
import org.eclipse.ecf.provider.generic.gmm.Member;
import org.eclipse.ecf.provider.generic.gmm.MemberChanged;

class SOContainerGMM
implements Observer {
    SOContainer container;
    Member localMember;
    GMMImpl groupManager;
    int maxMembers = -1;
    TreeMap loading;
    TreeMap active;
    static /* synthetic */ Class class$0;

    SOContainerGMM(SOContainer cont, Member local) {
        this.container = cont;
        this.groupManager = new GMMImpl();
        this.groupManager.addObserver(this);
        this.loading = new TreeMap();
        this.active = new TreeMap();
        this.localMember = local;
        this.addMember(local);
    }

    protected void debug(String msg) {
        if (Trace.shouldTrace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug")) {
            Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)(String.valueOf(msg) + ";container=" + this.container.getID() + ";existingmembers=" + this.groupManager));
        }
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SOContainerGMM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", clazz, (String)(this.container.getID() + ":" + msg), (Throwable)e);
    }

    ID[] getSharedObjectIDs() {
        return this.getActiveKeys();
    }

    synchronized boolean addMember(Member m) {
        this.debug("addMember(" + m.getID() + ")");
        if (this.maxMembers > 0 && this.getSize() > this.maxMembers) {
            return false;
        }
        return this.groupManager.addMember(m);
    }

    synchronized int setMaxMembers(int max) {
        this.debug("setMaxMembers(" + max + ")");
        int old = this.maxMembers;
        this.maxMembers = max;
        return old;
    }

    synchronized int getMaxMembers() {
        return this.maxMembers;
    }

    synchronized boolean removeMember(Member m) {
        boolean res = this.groupManager.removeMember(m);
        if (res) {
            this.removeSharedObjects(m);
        }
        return res;
    }

    synchronized boolean removeMember(ID id) {
        this.debug("removeMember(" + id + ")");
        Member m = this.getMemberForID(id);
        if (m == null) {
            return false;
        }
        return this.removeMember(m);
    }

    void removeAllMembers() {
        this.removeAllMembers(null);
    }

    void removeNonLocalMembers() {
        this.removeAllMembers(this.localMember);
    }

    synchronized void removeAllMembers(Member exception) {
        if (exception == null) {
            this.debug("removeAllMembers()");
        } else {
            this.debug("removeAllMembers(" + exception.getID() + ")");
        }
        Object[] m = this.getMembers();
        int i = 0;
        while (i < m.length) {
            Member mem = (Member)m[i];
            if (exception == null || !exception.equals(mem)) {
                this.removeMember(mem);
            }
            ++i;
        }
    }

    synchronized Object[] getMembers() {
        return this.groupManager.getMembers();
    }

    synchronized ID[] getOtherMemberIDs() {
        return this.groupManager.getMemberIDs(this.localMember.getID());
    }

    synchronized ID[] getMemberIDs() {
        return this.groupManager.getMemberIDs(null);
    }

    synchronized Member getMemberForID(ID id) {
        Member newMem = new Member(id);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Member oldMem = (Member)i.next();
            if (!newMem.equals(oldMem)) continue;
            return oldMem;
        }
        return null;
    }

    synchronized int getSize() {
        return this.groupManager.getSize();
    }

    synchronized boolean containsMember(Member m) {
        if (m != null) {
            this.debug("containsMember(" + m.getID() + ")");
        }
        return this.groupManager.containsMember(m);
    }

    synchronized Iterator iterator() {
        return this.groupManager.iterator();
    }

    synchronized boolean addSharedObject(SOWrapper ro) {
        if (ro != null) {
            this.debug("addSharedObject(" + ro.getObjID() + ")");
        }
        if (this.getFromAny(ro.getObjID()) != null) {
            return false;
        }
        this.addSharedObjectToActive(ro);
        return true;
    }

    synchronized boolean addLoadingSharedObject(SOContainer.LoadingSharedObject lso) {
        if (lso != null) {
            this.debug("addLoadingSharedObject(" + lso.getID() + ")");
        }
        if (this.getFromAny(lso.getID()) != null) {
            return false;
        }
        this.loading.put(lso.getID(), new SOWrapper(lso, this.container));
        lso.start();
        return true;
    }

    synchronized void moveSharedObjectFromLoadingToActive(SOWrapper ro) {
        if (ro != null) {
            this.debug("moveSharedObjectFromLoadingToActive(" + ro.getObjID() + ")");
        }
        if (this.removeSharedObjectFromLoading(ro.getObjID())) {
            this.addSharedObjectToActive(ro);
        }
    }

    boolean removeSharedObjectFromLoading(ID id) {
        this.debug("removeSharedObjectFromLoading(" + id + ")");
        return this.loading.remove(id) != null;
    }

    synchronized ID[] getActiveKeys() {
        return this.active.keySet().toArray(new ID[0]);
    }

    void addSharedObjectToActive(SOWrapper so) {
        if (so != null) {
            this.debug("addSharedObjectToActive(" + so.getObjID() + ")");
        }
        this.active.put(so.getObjID(), so);
        so.activated();
    }

    synchronized void notifyOthersActivated(ID id) {
        this.debug("notifyOthersActivated(" + id + ")");
        this.notifyOtherChanged(id, this.active, true);
    }

    synchronized void notifyOthersDeactivated(ID id) {
        this.debug("notifyOthersDeactivated(" + id + ")");
        this.notifyOtherChanged(id, this.active, false);
    }

    void notifyOtherChanged(ID id, TreeMap aMap, boolean activated) {
        Iterator i = aMap.values().iterator();
        while (i.hasNext()) {
            SOWrapper other = (SOWrapper)i.next();
            if (id.equals((Object)other.getObjID())) continue;
            other.otherChanged(id, activated);
        }
    }

    synchronized boolean removeSharedObject(ID id) {
        this.debug("removeSharedObject(" + id + ")");
        SOWrapper ro = this.removeFromMap(id, this.active);
        if (ro == null) {
            return false;
        }
        ro.deactivated();
        return true;
    }

    synchronized SOWrapper getFromMap(ID objID, TreeMap aMap) {
        return (SOWrapper)aMap.get(objID);
    }

    synchronized SOWrapper removeFromMap(ID objID, TreeMap aMap) {
        return (SOWrapper)aMap.remove(objID);
    }

    SOWrapper getFromLoading(ID objID) {
        return this.getFromMap(objID, this.loading);
    }

    SOWrapper getFromActive(ID objID) {
        return this.getFromMap(objID, this.active);
    }

    synchronized SOWrapper getFromAny(ID objID) {
        SOWrapper ro = this.getFromMap(objID, this.active);
        if (ro != null) {
            return ro;
        }
        ro = this.getFromMap(objID, this.loading);
        return ro;
    }

    void notifyAllOfMemberChange(Member m, TreeMap map, boolean add) {
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            SOWrapper ro = (SOWrapper)i.next();
            ro.memberChanged(m, add);
        }
    }

    public void update(Observable o, Object arg) {
        MemberChanged mc = (MemberChanged)arg;
        this.notifyAllOfMemberChange(mc.getMember(), this.active, mc.getAdded());
    }

    synchronized void removeSharedObjects(Member m) {
        this.removeSharedObjects(m, true);
    }

    synchronized void clear() {
        this.debug("clear()");
        this.removeSharedObjects(null, true);
    }

    void removeSharedObjects(Member m, boolean match) {
        HashSet set = this.getRemoveIDs(m.getID(), match);
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ID removeID = (ID)i.next();
            if (this.isLoading(removeID)) {
                this.removeSharedObjectFromLoading(removeID);
                continue;
            }
            this.container.destroySharedObject(removeID);
        }
    }

    HashSet getRemoveIDs(ID homeID, boolean match) {
        HashSet aSet = new HashSet();
        DestroyIterator i = new DestroyIterator(this.loading, homeID, match);
        while (i.hasNext()) {
            aSet.add(i.next());
        }
        i = new DestroyIterator(this.active, homeID, match);
        while (i.hasNext()) {
            aSet.add(i.next());
        }
        return aSet;
    }

    synchronized boolean isActive(ID id) {
        return this.active.containsKey(id);
    }

    synchronized boolean isLoading(ID id) {
        return this.loading.containsKey(id);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SOContainerGMM[");
        sb.append(this.groupManager);
        sb.append(";load:").append(this.loading);
        sb.append(";active:").append(this.active).append("]");
        return sb.toString();
    }
}

