/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.discovery.IContainerServiceInfoAdapter;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.discovery.DiscoveryPlugin;
import org.eclipse.ecf.internal.discovery.Messages;

public class ServiceInfo
implements IServiceInfo,
Serializable,
IContainerServiceInfoAdapter {
    private static final long serialVersionUID = -5651115550295457142L;
    public static final int DEFAULT_PRIORITY = -1;
    public static final int DEFAULT_WEIGHT = -1;
    public static final String UNKNOWN_PROTOCOL = "unknown";
    protected URI uri = null;
    protected IServiceID serviceID;
    protected int priority;
    protected int weight;
    protected IServiceProperties properties;

    protected ServiceInfo() {
    }

    public ServiceInfo(URI anURI, IServiceID serviceID, int priority, int weight, IServiceProperties props) {
        this.uri = anURI;
        Assert.isNotNull((Object)this.uri);
        this.serviceID = serviceID;
        Assert.isNotNull((Object)serviceID);
        this.priority = priority;
        this.weight = weight;
        this.properties = props == null ? new ServiceProperties() : props;
    }

    public ServiceInfo(String protocol, String host, int port, IServiceID serviceID, int priority, int weight, IServiceProperties props) {
        try {
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            this.uri = new URI(protocol == null ? UNKNOWN_PROTOCOL : protocol, null, host, port, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(Messages.ServiceInfo_EXCEPTION_INVALID_HOST_ARG);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(Messages.ServiceInfo_EXCEPTION_NO_LOCALHOST);
        }
        this.serviceID = serviceID;
        Assert.isNotNull((Object)serviceID);
        this.priority = priority;
        this.weight = weight;
        this.properties = props == null ? new ServiceProperties() : props;
    }

    public ServiceInfo(String protocol, String host, int port, IServiceID serviceID, IServiceProperties props) {
        this(protocol, host, port, serviceID, -1, -1, props);
    }

    public ServiceInfo(String protocol, String host, int port, IServiceID serviceID) {
        this(protocol, host, port, serviceID, (IServiceProperties)new ServiceProperties());
    }

    public ServiceInfo(URI anURI, IServiceID serviceID, IServiceProperties props) {
        this(anURI, serviceID, -1, -1, props);
    }

    public ServiceInfo(URI anURI, IServiceID serviceID) {
        this(anURI, serviceID, -1, -1, (IServiceProperties)new ServiceProperties());
    }

    public URI getLocation() {
        return this.uri;
    }

    protected void setLocation(URI address) {
        this.uri = address;
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public IServiceProperties getServiceProperties() {
        return this.properties;
    }

    public boolean isResolved() {
        return this.uri != null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceInfo[");
        buf.append("uri=").append(this.uri).append(";id=").append(this.serviceID).append(";priority=").append(this.priority).append(";weight=").append(this.weight).append(";props=").append(this.properties).append("]");
        return buf.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = DiscoveryPlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String getContainerFactoryName() {
        return this.properties == null ? null : this.properties.getPropertyString("org.eclipse.ecf.containerFactoryName");
    }

    public String getConnectTarget() {
        if (this.uri == null || this.properties == null) {
            return null;
        }
        String connectTarget = this.properties.getPropertyString("org.eclipse.ecf.connectTarget");
        if (connectTarget != null) {
            return connectTarget;
        }
        String t = this.properties.getPropertyString("org.eclipse.ecf.connectTargetProtocol");
        if (t == null) {
            return null;
        }
        StringBuffer target = new StringBuffer(t);
        String auth = this.uri.getAuthority();
        String path = this.properties.getPropertyString("org.eclipse.ecf.connectTargetPath");
        if (path == null) {
            path = "/";
        }
        target.append("://").append(auth).append("/").append(path);
        return target.toString();
    }

    public void setContainerProperties(String containerFactoryName, String connectProtocol, String connectPath, Boolean connectRequiresPassword) {
        Assert.isNotNull((Object)containerFactoryName);
        this.properties.setPropertyString("org.eclipse.ecf.containerFactoryName", containerFactoryName);
        Assert.isNotNull((Object)connectProtocol);
        this.properties.setPropertyString("org.eclipse.ecf.connectTargetProtocol", connectProtocol);
        if (connectPath != null) {
            this.properties.setPropertyString("org.eclipse.ecf.connectTargetPath", connectPath);
        }
        if (connectRequiresPassword != null) {
            this.properties.setPropertyString("org.eclipse.ecf.connectContextRequiresPassword", connectRequiresPassword.toString());
        }
    }

    public Boolean connectRequiresPassword() {
        String b = this.properties.getPropertyString("org.eclipse.ecf.connectContextRequiresPassword");
        if (b == null) {
            return null;
        }
        return Boolean.valueOf(b);
    }

    public void setContainerProperties(String containerFactoryName, String connectTarget, Boolean connectRequiresPassword) {
        Assert.isNotNull((Object)containerFactoryName);
        this.properties.setPropertyString("org.eclipse.ecf.containerFactoryName", containerFactoryName);
        Assert.isNotNull((Object)connectTarget);
        this.properties.setPropertyString("org.eclipse.ecf.connectTarget", connectTarget);
        if (connectRequiresPassword != null) {
            this.properties.setPropertyString("org.eclipse.ecf.connectContextRequiresPassword", connectRequiresPassword.toString());
        }
    }
}

