/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.identity;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public class ServiceID
extends BaseID
implements IServiceID {
    private static final long serialVersionUID = 4362768703249025783L;
    protected IServiceTypeID type;
    protected String name;

    protected ServiceID(Namespace namespace, IServiceTypeID type, String name) {
        super(namespace);
        Assert.isNotNull((Object)type);
        this.type = type;
        this.name = name;
    }

    protected String getFullyQualifiedName() {
        if (this.name == null) {
            return this.type.getName();
        }
        return String.valueOf(this.type.getName()) + "@" + this.name;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o instanceof ServiceID) {
            ServiceID other = (ServiceID)o;
            String typename = other.getFullyQualifiedName();
            return this.getFullyQualifiedName().compareTo(typename);
        }
        return 1;
    }

    protected boolean namespaceEquals(BaseID o) {
        ServiceID other;
        if (o == null) {
            return false;
        }
        return o instanceof ServiceID && (other = (ServiceID)o).getName().equals(this.getName());
    }

    protected String namespaceGetName() {
        return this.getFullyQualifiedName();
    }

    protected int namespaceHashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public String getServiceType() {
        return this.type.getName();
    }

    public IServiceTypeID getServiceTypeID() {
        return this.type;
    }

    public String getServiceName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceID[");
        buf.append("type=").append(this.type).append(";name=").append(this.name).append(";full=" + this.getFullyQualifiedName()).append("]");
        return buf.toString();
    }
}

