/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class BreadcrumbsFilter
implements IFilter {
    private static final String HEAD_CONTENT = "\n<link rel=\"stylesheet\" href=\"../content/PLUGINS_ROOT/org.eclipse.help.webapp/advanced/breadcrumbs.css\" charset=\"ISO-8859-1\" type=\"text/css\"></link>\n<script type=\"text/javascript\" src=\"../content/PLUGINS_ROOT/org.eclipse.help/livehelp.js\"> </script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !UrlUtil.isNavPath(uri)) {
            return out;
        }
        if ("/rtopic".equals(req.getServletPath())) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        String servletPath = req.getServletPath();
        if (pathInfo == null || servletPath == null) {
            return out;
        }
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        String showBreadcrumbs = prefs.getString("showBreadcrumbs");
        if ("false".equalsIgnoreCase(showBreadcrumbs)) {
            try {
                return new FilterHTMLHeadOutputStream(out, HEAD_CONTENT.getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String locale = UrlUtil.getLocale(req, null);
        int[] path = UrlUtil.getTopicPath(String.valueOf(servletPath) + pathInfo, locale);
        if (path != null && path.length > 1) {
            try {
                boolean isNarrow = "/ntopic".equals(req.getServletPath());
                String bodyContent = this.getBodyContent(path, this.getBackpath(pathInfo), isNarrow, locale);
                return new FilterHTMLHeadAndBodyOutputStream(out, HEAD_CONTENT.getBytes("ASCII"), bodyContent);
            }
            catch (Exception exception) {
                return out;
            }
        }
        return out;
    }

    private String getBackpath(String path) {
        int num = new Path(path).segmentCount();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    private String getBodyContent(int[] path, String backPath, boolean isNarrow, String locale) {
        StringBuffer buf = new StringBuffer();
        StringBuffer pathBuf = new StringBuffer();
        ITopic topic = HelpPlugin.getTocManager().getTocs(locale)[path[0]].getTopic(null);
        pathBuf.append(path[0]);
        buf.append("<div class=\"help_breadcrumbs\">");
        int i = 0;
        while (i < path.length - 1) {
            buf.append("<a href=\"");
            String href = topic.getHref();
            href = href != null ? String.valueOf(backPath) + (isNarrow ? "/ntopic" : "/topic") + href : (isNarrow ? "javascript:liveAction('org.eclipse.help.ui', 'org.eclipse.help.ui.internal.ShowInTocAction', '" + pathBuf.toString() + "')" : String.valueOf(backPath) + "/nav/" + pathBuf.toString());
            buf.append(href);
            buf.append("\">");
            buf.append(topic.getLabel());
            buf.append("</a>");
            if (i < path.length - 2 || path.length == 2) {
                buf.append(" > ");
            }
            topic = topic.getSubtopics()[path[i + 1]];
            pathBuf.append('_');
            pathBuf.append(path[i + 1]);
            ++i;
        }
        buf.append("</div>");
        return buf.toString();
    }
}

