/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.container.help;

import java.io.File;
import java.net.URI;
import org.eclipse.corona.internal.container.help.Activator;
import org.eclipse.corona.server.AbstractServerApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.help.standalone.Infocenter;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Application
extends AbstractServerApplication {
    private LogService logService = Activator.getDefault().getLogService();
    private static final String SERVER_NAME = "HelpContainer";
    private static final String PORT = "port";
    private static final String DEFAULT_PORT = "8088";
    private Infocenter infoCenter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext iApplicationContext) throws Exception {
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        Object object = super.start(bundleContext, iApplicationContext, SERVER_NAME);
        URI uRI = new URI(System.getProperty("osgi.install.area"));
        File file = new File(uRI);
        String[] stringArray = new String[]{"-eclipseHome", file.getAbsolutePath(), "-port", this.getProperty(PORT), "-noexec"};
        try {
            this.logService.log(3, "...starting Help Container InfoCenter");
            this.infoCenter = new Infocenter(stringArray);
            this.infoCenter.start();
            Infocenter infocenter = this.infoCenter;
            synchronized (infocenter) {
                this.infoCenter.wait();
            }
        }
        catch (Throwable throwable) {
            this.logService.log(2, "Failed to start Infocenter", throwable);
            object = new Integer(-1);
        }
        if (this.infoCenter != null) {
            this.infoCenter.shutdown();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Infocenter infocenter = this.infoCenter;
        synchronized (infocenter) {
            this.infoCenter.notify();
        }
        super.stop();
    }

    protected void initialize() {
        super.initialize();
        String string = this.getProperty(PORT);
        if (string == null) {
            this.setProperty(PORT, DEFAULT_PORT);
        }
    }
}

