/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diagnostic.data;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.corona.diagnostic.data.ServiceReferenceData;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class BundleData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, Object> properties;
    private long bundleID;
    private int bundleState;

    public BundleData(Bundle bundle) {
        this.bundleID = bundle.getBundleId();
        this.bundleState = bundle.getState();
        this.properties = new Hashtable();
        this.saveHeaderProperties(bundle);
        this.saveServiceRegistrations(bundle);
    }

    private void saveHeaderProperties(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)dictionary.get(string);
            this.addProperty(string, string2);
        }
    }

    private void saveServiceRegistrations(Bundle bundle) {
        ServiceReference[] serviceReferenceArray = bundle.getRegisteredServices();
        if (serviceReferenceArray != null) {
            ServiceReferenceData[] serviceReferenceDataArray = new ServiceReferenceData[serviceReferenceArray.length];
            int n = 0;
            while (n < serviceReferenceDataArray.length) {
                serviceReferenceDataArray[n] = new ServiceReferenceData(serviceReferenceArray[n]);
                ++n;
            }
        }
    }

    private void addProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public long getBundleID() {
        return this.bundleID;
    }

    public int getBundleState() {
        return this.bundleState;
    }
}

