/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.corona.CoronaException;
import org.eclipse.corona.internal.Activator;
import org.eclipse.corona.server.IApplicationManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManager
implements IApplicationManager {
    private LogService logService = Activator.getDefault().getLogService();
    private BundleContext ctxBundle;
    private ServiceTracker appDescriptors;
    private ServiceTracker appHandles;
    private Filter filterRunningApp;
    private static final String FILTER_RUNNING_APP = "(!(application.state=STOPPING))";
    private static final String FILTER_VISIBLE = "(application.visible=true)";
    private static final String ATTR_APP_STATE = "application.state";
    private static final String STATE_RUNNING = "RUNNING";
    private Hashtable<String, ApplicationHandle> listStartedApps = new Hashtable();

    protected void activate(ComponentContext componentContext) throws CoronaException {
        this.logService.log(4, "activate ApplicationManager");
        this.ctxBundle = componentContext.getBundleContext();
        try {
            this.filterRunningApp = this.ctxBundle.createFilter(FILTER_RUNNING_APP);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            String string = "Invalid filter syntax: (!(application.state=STOPPING))";
            this.logService.log(1, string);
            CoronaException coronaException = new CoronaException(string);
            coronaException.initCause(invalidSyntaxException);
            throw coronaException;
        }
        this.appDescriptors = new ServiceTracker(this.ctxBundle, ApplicationDescriptor.class.getName(), null);
        this.appDescriptors.open();
        this.appHandles = new ServiceTracker(this.ctxBundle, ApplicationHandle.class.getName(), null);
        this.appHandles.open();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.logService.log(4, "deactivate ApplicationManager");
        this.appHandles.close();
        this.appHandles = null;
        this.appDescriptors.close();
        this.appDescriptors = null;
        this.ctxBundle = null;
    }

    @Override
    public void startApplication(String string) throws CoronaException {
        this.logService.log(4, "starting application: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(1);
        if (stringArray != null) {
            hashMap.put("application.args", stringArray);
        }
        this.startApplication(string2, hashMap);
    }

    protected void startApplication(String string, HashMap<String, String[]> hashMap) throws CoronaException {
        this.logService.log(4, "starting application: " + string);
        ServiceReference serviceReference = this.getServiceReference(this.appDescriptors.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            String string2 = "Unable to find application service component: " + string;
            this.logService.log(2, string2);
            throw new CoronaException(string2);
        }
        ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.ctxBundle.getService(serviceReference);
        try {
            try {
                ApplicationHandle applicationHandle = applicationDescriptor.launch(hashMap);
                this.listStartedApps.put(string, applicationHandle);
            }
            catch (Throwable throwable) {
                String string3 = "Failed to start application: " + string;
                this.logService.log(2, string3, throwable);
                CoronaException coronaException = new CoronaException(string3);
                coronaException.initCause(throwable);
                throw coronaException;
            }
        }
        finally {
            this.ctxBundle.ungetService(serviceReference);
        }
    }

    @Override
    public void stopApplication(String string) throws CoronaException {
        this.logService.log(4, "Stopping aplication: " + string);
        ApplicationHandle applicationHandle = this.listStartedApps.get(string);
        if (applicationHandle == null) {
            String string2 = "Cannot stop application that ApplicationManager did not start: " + string;
            this.logService.log(2, string2);
            throw new CoronaException(string2);
        }
        this.listStartedApps.remove(string);
        ApplicationHandle applicationHandle2 = this.getRunningApplication(string);
        if (applicationHandle2 == null) {
            this.logService.log(3, "Unable to stop non-running application: " + string);
        } else if (applicationHandle.equals(applicationHandle2)) {
            applicationHandle2.destroy();
        } else {
            this.logService.log(2, "Unable to stop application - different instance: " + string);
        }
    }

    @Override
    public void stopAllApplications() throws CoronaException {
        this.logService.log(4, "stopping all applications");
        Enumeration<String> enumeration = this.listStartedApps.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.stopApplication(string);
        }
    }

    @Override
    public int countRunningApplications() {
        int n = 0;
        Enumeration<String> enumeration = this.listStartedApps.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ApplicationHandle applicationHandle = this.listStartedApps.get(string);
            ApplicationHandle applicationHandle2 = this.getRunningApplication(string);
            if (applicationHandle2 == null || !applicationHandle.equals(applicationHandle2)) {
                this.listStartedApps.remove(string);
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public boolean isApplicationRunning(String string) {
        boolean bl = false;
        ApplicationHandle applicationHandle = this.listStartedApps.get(string);
        if (applicationHandle != null) {
            ApplicationHandle applicationHandle2 = this.getRunningApplication(string);
            if (applicationHandle2 != null || applicationHandle.equals(applicationHandle2)) {
                bl = true;
            } else {
                this.listStartedApps.remove(string);
            }
        }
        return bl;
    }

    private ApplicationHandle getRunningApplication(String string) {
        ApplicationHandle applicationHandle = null;
        ServiceReference serviceReference = this.getServiceReference(this.appHandles.getServiceReferences(), string, "service.pid", false);
        if (serviceReference == null) {
            serviceReference = this.getServiceReference(this.appHandles.getServiceReferences(), string, "application.descriptor", false);
        }
        if (serviceReference == null) {
            this.logService.log(3, "unable to find application: " + string);
        } else if (this.filterRunningApp.match(this.getProperties(serviceReference))) {
            try {
                applicationHandle = (ApplicationHandle)this.ctxBundle.getService(serviceReference);
            }
            finally {
                this.ctxBundle.ungetService(serviceReference);
            }
        }
        return applicationHandle;
    }

    private ServiceReference getServiceReference(ServiceReference[] serviceReferenceArray, String string, String string2, boolean bl) {
        if (serviceReferenceArray == null || string == null) {
            return null;
        }
        ServiceReference serviceReference = null;
        boolean bl2 = false;
        int n = 0;
        while (n < serviceReferenceArray.length) {
            String string3 = (String)serviceReferenceArray[n].getProperty(string2);
            if (string.equals(string3)) {
                return serviceReferenceArray[n];
            }
            if (!bl && string3.indexOf(string) >= 0) {
                if (serviceReference != null) {
                    bl2 = true;
                }
                serviceReference = serviceReferenceArray[n];
            }
            ++n;
        }
        return bl2 ? null : serviceReference;
    }

    public Dictionary<String, Object> getProperties(ServiceReference serviceReference) {
        String[] stringArray = serviceReference.getPropertyKeys();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], serviceReference.getProperty(stringArray[n]));
            ++n;
        }
        return hashtable;
    }

    @Override
    public String[] listApplications() {
        String[] stringArray = null;
        ServiceReference[] serviceReferenceArray = this.appDescriptors.getServiceReferences();
        if (serviceReferenceArray != null && serviceReferenceArray.length > 0) {
            stringArray = new String[serviceReferenceArray.length];
            int n = 0;
            while (n < serviceReferenceArray.length) {
                stringArray[n] = (String)serviceReferenceArray[n].getProperty("service.pid");
                ++n;
            }
        }
        return stringArray;
    }
}

