/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.taskdefs.optional.script.ScriptDefBase;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.ScriptRunnerBase;
import org.apache.tools.ant.util.ScriptRunnerHelper;

public class ScriptDef
extends DefBase {
    private ScriptRunnerHelper helper = new ScriptRunnerHelper();
    private ScriptRunnerBase runner = null;
    private String name;
    private List attributes = new ArrayList();
    private List nestedElements = new ArrayList();
    private Set attributeSet;
    private Map nestedElementMap;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$script$ScriptDef;

    public void setProject(Project project) {
        super.setProject(project);
        this.helper.setProjectComponent((ProjectComponent)this);
        this.helper.setSetBeans(false);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAttributeSupported(String attributeName) {
        return this.attributeSet.contains(attributeName);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void addElement(NestedElement nestedElement) {
        this.nestedElements.add(nestedElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Project p;
        if (this.name == null) {
            throw new BuildException("scriptdef requires a name attribute to name the script");
        }
        if (this.helper.getLanguage() == null) {
            throw new BuildException("<scriptdef> requires a language attribute to specify the script language");
        }
        if (this.getAntlibClassLoader() != null || this.hasCpDelegate()) {
            this.helper.setClassLoader(this.createLoader());
        }
        this.runner = this.helper.getScriptRunner();
        this.attributeSet = new HashSet();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (attribute.name == null) {
                throw new BuildException("scriptdef <attribute> elements must specify an attribute name");
            }
            if (this.attributeSet.contains(attribute.name)) {
                throw new BuildException("scriptdef <" + this.name + "> declares " + "the " + attribute.name + " attribute more than once");
            }
            this.attributeSet.add(attribute.name);
        }
        this.nestedElementMap = new HashMap();
        i = this.nestedElements.iterator();
        while (i.hasNext()) {
            NestedElement nestedElement = (NestedElement)i.next();
            if (nestedElement.name == null) {
                throw new BuildException("scriptdef <element> elements must specify an element name");
            }
            if (this.nestedElementMap.containsKey(nestedElement.name)) {
                throw new BuildException("scriptdef <" + this.name + "> declares " + "the " + nestedElement.name + " nested element more " + "than once");
            }
            if (nestedElement.className == null && nestedElement.type == null) {
                throw new BuildException("scriptdef <element> elements must specify either a classname or type attribute");
            }
            if (nestedElement.className != null && nestedElement.type != null) {
                throw new BuildException("scriptdef <element> elements must specify only one of the classname and type attributes");
            }
            this.nestedElementMap.put(nestedElement.name, nestedElement);
        }
        HashMap<String, ScriptDef> scriptRepository = null;
        Project project = p = this.getProject();
        synchronized (project) {
            scriptRepository = (HashMap<String, ScriptDef>)p.getReference("org.apache.ant.scriptrepo");
            if (scriptRepository == null) {
                scriptRepository = new HashMap<String, ScriptDef>();
                p.addReference("org.apache.ant.scriptrepo", scriptRepository);
            }
        }
        this.name = ProjectHelper.genComponentName((String)this.getURI(), (String)this.name);
        scriptRepository.put(this.name, this);
        AntTypeDefinition def = new AntTypeDefinition();
        def.setName(this.name);
        def.setClass(class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase == null ? (class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase = ScriptDef.class$("org.apache.tools.ant.taskdefs.optional.script.ScriptDefBase")) : class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase);
        ComponentHelper.getComponentHelper((Project)this.getProject()).addDataTypeDefinition(def);
    }

    public Object createNestedElement(String elementName) {
        NestedElement definition = (NestedElement)this.nestedElementMap.get(elementName);
        if (definition == null) {
            throw new BuildException("<" + this.name + "> does not support " + "the <" + elementName + "> nested element");
        }
        Object instance = null;
        String classname = definition.className;
        if (classname == null) {
            instance = this.getProject().createTask(definition.type);
            if (instance == null) {
                instance = this.getProject().createDataType(definition.type);
            }
        } else {
            ClassLoader loader = this.createLoader();
            try {
                instance = ClasspathUtils.newInstance((String)classname, (ClassLoader)loader);
            }
            catch (BuildException e) {
                instance = ClasspathUtils.newInstance((String)classname, (ClassLoader)(class$org$apache$tools$ant$taskdefs$optional$script$ScriptDef == null ? (class$org$apache$tools$ant$taskdefs$optional$script$ScriptDef = ScriptDef.class$("org.apache.tools.ant.taskdefs.optional.script.ScriptDef")) : class$org$apache$tools$ant$taskdefs$optional$script$ScriptDef).getClassLoader());
            }
            this.getProject().setProjectReference(instance);
        }
        if (instance == null) {
            throw new BuildException("<" + this.name + "> is unable to create " + "the <" + elementName + "> nested element");
        }
        return instance;
    }

    public void executeScript(Map attributes, Map elements) {
        this.executeScript(attributes, elements, null);
    }

    public void executeScript(Map attributes, Map elements, ScriptDefBase instance) {
        this.runner.addBean("attributes", (Object)attributes);
        this.runner.addBean("elements", (Object)elements);
        this.runner.addBean("project", (Object)this.getProject());
        if (instance != null) {
            this.runner.addBean("self", (Object)instance);
        }
        this.runner.executeScript("scriptdef_" + this.name);
    }

    public void setManager(String manager) {
        this.helper.setManager(manager);
    }

    public void setLanguage(String language) {
        this.helper.setLanguage(language);
    }

    public void setSrc(File file) {
        this.helper.setSrc(file);
    }

    public void addText(String text) {
        this.helper.addText(text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Attribute {
        private String name;

        public void setName(String name) {
            this.name = name.toLowerCase(Locale.US);
        }
    }

    public static class NestedElement {
        private String name;
        private String type;
        private String className;

        public void setName(String name) {
            this.name = name.toLowerCase(Locale.US);
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setClassName(String className) {
            this.className = className;
        }
    }
}

