/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.transforms.CSVParser;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TransformInstanceListData
extends ServiceTracker {
    private static final String[] EMPTY_TYPES = new String[0];
    private volatile boolean stale;
    private Map transformerToTuple;
    private List rawTuples;
    private Map bundleIdToTransformPresence;
    static /* synthetic */ Class class$0;

    public TransformInstanceListData(BundleContext context) throws InvalidSyntaxException {
        StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, context.createFilter(stringBuffer.append(clazz.getName()).append(")(").append("equinox.transformerType").append("=*))").toString()), null);
        this.stale = true;
        this.transformerToTuple = new HashMap();
        this.rawTuples = new ArrayList();
        this.bundleIdToTransformPresence = new HashMap();
        this.open();
    }

    public synchronized String[] getTransformTypes() {
        if (this.stale) {
            this.rebuildTransformMap();
        }
        if (this.transformerToTuple.size() == 0) {
            return EMPTY_TYPES;
        }
        return this.transformerToTuple.keySet().toArray(new String[this.transformerToTuple.size()]);
    }

    public synchronized TransformTuple[] getTransformsFor(String type) {
        if (this.stale) {
            this.rebuildTransformMap();
        }
        return (TransformTuple[])this.transformerToTuple.get(type);
    }

    public synchronized boolean hasTransformsFor(Bundle bundle) {
        String bundleName;
        Boolean hasTransformsFor;
        if (this.stale) {
            this.rebuildTransformMap();
        }
        if ((hasTransformsFor = (Boolean)this.bundleIdToTransformPresence.get(bundleName = bundle.getSymbolicName())) == null) {
            hasTransformsFor = Boolean.FALSE;
            Iterator i = this.rawTuples.iterator();
            while (i.hasNext()) {
                TransformTuple tuple = (TransformTuple)i.next();
                if (!tuple.bundlePattern.matcher(bundleName).matches()) continue;
                hasTransformsFor = Boolean.TRUE;
            }
            this.bundleIdToTransformPresence.put(bundleName, hasTransformsFor);
        }
        return hasTransformsFor;
    }

    private void rebuildTransformMap() {
        this.transformerToTuple.clear();
        this.rawTuples.clear();
        this.bundleIdToTransformPresence.clear();
        ServiceReference[] serviceReferences = this.getServiceReferences();
        this.stale = false;
        if (serviceReferences == null) {
            return;
        }
        int i = 0;
        while (i < serviceReferences.length) {
            ServiceReference serviceReference = serviceReferences[i];
            String type = serviceReference.getProperty("equinox.transformerType").toString();
            URL url = (URL)this.getService(serviceReference);
            try {
                TransformTuple[] transforms = CSVParser.parse(url);
                TransformTuple[] existing = (TransformTuple[])this.transformerToTuple.get(type);
                if (existing != null) {
                    TransformTuple[] newTransforms = new TransformTuple[existing.length + transforms.length];
                    System.arraycopy(existing, 0, newTransforms, 0, existing.length);
                    System.arraycopy(transforms, 0, newTransforms, existing.length, transforms.length);
                    this.transformerToTuple.put(type, newTransforms);
                } else {
                    this.transformerToTuple.put(type, transforms);
                }
                int j = 0;
                while (j < transforms.length) {
                    this.rawTuples.add(transforms[j]);
                    ++j;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public Object addingService(ServiceReference reference) {
        try {
            Object object = super.addingService(reference);
            return object;
        }
        finally {
            this.stale = true;
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
        this.stale = true;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        this.stale = true;
    }
}

