/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.diagnostic;

import org.eclipse.corona.diagnostic.IDiagnosticManager;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class DiagCommands
implements CommandProvider {
    private static String help = "---Corona Diagnostics---\n\t diagDump - dump diagnostic data components\n\t diagList - list diagnostic data components\n";
    private BundleContext ctxBundle;

    protected void activate(ComponentContext componentContext) {
        this.ctxBundle = componentContext.getBundleContext();
    }

    public String getHelp() {
        return help;
    }

    public void _diagDump(CommandInterpreter commandInterpreter) {
        commandInterpreter.println((Object)"Dumping Diagnostic Data...");
        String string = commandInterpreter.nextArgument();
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(IDiagnosticManager.class.getName());
            if (serviceReference != null) {
                IDiagnosticManager iDiagnosticManager = (IDiagnosticManager)this.ctxBundle.getService(serviceReference);
                String string2 = iDiagnosticManager.dumpData(string);
                commandInterpreter.println((Object)("diagnostic dump file written to: " + string2));
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
    }

    public void _diagList(CommandInterpreter commandInterpreter) {
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(IDiagnosticManager.class.getName());
            if (serviceReference != null) {
                IDiagnosticManager iDiagnosticManager = (IDiagnosticManager)this.ctxBundle.getService(serviceReference);
                String[] stringArray = iDiagnosticManager.listDiagnosticData();
                int n = 0;
                while (n < stringArray.length) {
                    commandInterpreter.println((Object)("...IDiagnosticData: " + stringArray[n]));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
    }
}

