/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.test;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestCommands
implements CommandProvider,
EventHandler {
    private ServiceRegistration srvRegEventHandler;
    private static String help = "---Corona Test Framework---\n\t testList - list all of test suites\n\t testAll - run ALL test suites\n\t testSuite <name> - run test suite 'name'\n";
    private BundleContext ctxBundle;
    private CommandInterpreter cmdInterpreter;

    protected void activate(ComponentContext componentContext) {
        this.ctxBundle = componentContext.getBundleContext();
        String[] stringArray = new String[]{"event.topics", "org/eclipse/corona/test/*"};
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("event.topics", stringArray);
        this.srvRegEventHandler = this.ctxBundle.registerService(EventHandler.class.getName(), (Object)this, hashtable);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.srvRegEventHandler.unregister();
        this.srvRegEventHandler = null;
        this.ctxBundle = null;
    }

    public String getHelp() {
        return help;
    }

    public void _testAll(CommandInterpreter commandInterpreter) {
        Object object;
        commandInterpreter.println((Object)"Running ALL test cases...");
        ITestSummary[] iTestSummaryArray = null;
        try {
            object = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (object != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(object);
                this.cmdInterpreter = commandInterpreter;
                iTestSummaryArray = iTestManager.runAllTestSuites();
                Thread.sleep(2000L);
                this.cmdInterpreter = null;
                this.ctxBundle.ungetService(object);
            } else {
                commandInterpreter.println((Object)"Warning: unable to locate TestManager service");
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSummaryArray != null) {
            ITestSummary[] iTestSummaryArray2 = iTestSummaryArray;
            int n = iTestSummaryArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = iTestSummaryArray2[n2];
                this.printTestSummary(commandInterpreter, (ITestSummary)object);
                ++n2;
            }
        } else {
            commandInterpreter.println((Object)"Warning: not test summary results to report");
        }
    }

    public void _testSuite(CommandInterpreter commandInterpreter) {
        commandInterpreter.println((Object)"Running test suite...");
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println((Object)"\tERROR: test suite name not defined");
            return;
        }
        ITestSummary iTestSummary = null;
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (serviceReference != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(serviceReference);
                this.cmdInterpreter = commandInterpreter;
                ITestSuite[] iTestSuiteArray = iTestManager.testSuites();
                int n = 0;
                while (n < iTestSuiteArray.length) {
                    if (iTestSuiteArray[n].getName().equals(string)) {
                        iTestSummary = iTestManager.runTestSuite(iTestSuiteArray[n]);
                        break;
                    }
                    ++n;
                }
                Thread.sleep(2000L);
                this.cmdInterpreter = null;
                this.ctxBundle.ungetService(serviceReference);
            } else {
                commandInterpreter.println((Object)"Warning: unable to locate TestManager service");
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSummary != null) {
            this.printTestSummary(commandInterpreter, iTestSummary);
        } else {
            commandInterpreter.println((Object)"Warning: not test summary results to report");
        }
    }

    private void printTestSummary(CommandInterpreter commandInterpreter, ITestSummary iTestSummary) {
        commandInterpreter.println((Object)iTestSummary.toString());
    }

    public void _testList(CommandInterpreter commandInterpreter) throws InvalidSyntaxException, CoreException {
        commandInterpreter.println((Object)"Listing all test suites...");
        ITestSuite[] iTestSuiteArray = null;
        try {
            ServiceReference serviceReference = this.ctxBundle.getServiceReference(ITestManager.class.getName());
            if (serviceReference != null) {
                ITestManager iTestManager = (ITestManager)this.ctxBundle.getService(serviceReference);
                iTestSuiteArray = iTestManager.testSuites();
                this.ctxBundle.ungetService(serviceReference);
            }
        }
        catch (Exception exception) {
            commandInterpreter.printStackTrace((Throwable)exception);
        }
        if (iTestSuiteArray != null) {
            int n = 0;
            while (n < iTestSuiteArray.length) {
                commandInterpreter.println((Object)("\tITestSuite: " + iTestSuiteArray[n].getName()));
                commandInterpreter.println((Object)("\t\t  type: " + iTestSuiteArray[n].getRunnerType()));
                commandInterpreter.println((Object)("\t\t level: " + iTestSuiteArray[n].getLevel()));
                ++n;
            }
        }
    }

    public synchronized void handleEvent(Event event) {
        if (this.cmdInterpreter != null) {
            String string;
            String string2 = (String)event.getProperty("event");
            ITestSuite iTestSuite = (ITestSuite)event.getProperty("test.suite");
            String string3 = (String)event.getProperty("test.case");
            if (string3 == null) {
                string3 = "";
            }
            if ((string = (String)event.getProperty("test.status")) == null) {
                string = "unknown";
            }
            this.cmdInterpreter.println((Object)"...testing progress:");
            this.cmdInterpreter.println((Object)("\t TestSuite: " + iTestSuite.getName()));
            this.cmdInterpreter.println((Object)("\t  TestCase: " + string3));
            this.cmdInterpreter.println((Object)("\t     State: " + string2));
            this.cmdInterpreter.println((Object)("\t    Status: " + string));
        }
    }
}

