/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.corona.test.ITestFailure;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;

public class TestSummary
implements ITestSummary {
    private long tsRunStart;
    private long tsRunStop;
    private String[] output;
    private ITestSuite testSuite;
    private ITestResult testResult;

    public TestSummary() {
        this.start();
    }

    public void initialize(ITestSuite iTestSuite, ITestResult iTestResult, String[] stringArray) {
        this.testSuite = iTestSuite;
        this.output = stringArray;
        this.testResult = iTestResult;
    }

    public void start() {
        this.tsRunStart = System.currentTimeMillis();
    }

    public void stop() {
        this.tsRunStop = System.currentTimeMillis();
    }

    public long getRunStartTime() {
        return this.tsRunStart;
    }

    public long getRunStopTime() {
        return this.tsRunStop;
    }

    public String[] getOutput() {
        return this.output;
    }

    public String getName() {
        return this.testSuite.getName();
    }

    public int getLevel() {
        return this.testSuite.getLevel();
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    public ITestResult getTestResult() {
        return this.testResult;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tTest Suite: " + this.getName() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("\tTime\n");
        long l = this.getRunStartTime();
        long l2 = this.getRunStopTime();
        double d = ((double)l2 - (double)l) / 1000.0;
        stringBuffer.append("\t\t   Start: " + new Date(l) + "\n");
        stringBuffer.append("\t\t    Stop: " + new Date(l2) + "\n");
        stringBuffer.append("\t\t Elapsed: " + d + " (seconds)\n");
        ITestResult iTestResult = this.getTestResult();
        stringBuffer.append("\tCounts\n");
        stringBuffer.append("\t\t Run     : " + iTestResult.getRunCount() + "\n");
        stringBuffer.append("\t\t Failures: " + iTestResult.getFailureCount() + "\n");
        stringBuffer.append("\t\t Ignore  : " + iTestResult.getIgnoreCount() + "\n");
        stringBuffer.append("\tResult: " + (iTestResult.wasSuccessful() ? "Pass" : "Fail\n"));
        ITestFailure[] iTestFailureArray = iTestResult.listFailures();
        int n = 0;
        while (n < iTestFailureArray.length) {
            stringBuffer.append("\tTest Failure\n");
            ITestFailure iTestFailure = iTestFailureArray[n];
            stringBuffer.append("\t\t Name: " + iTestFailure.getTestDescription() + "\n");
            stringBuffer.append("\t\t Message: " + iTestFailure.getMessage() + "\n");
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = iTestFailure.getTrace();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            int n2 = 0;
            while (n2 < 3 && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                stringBuffer2.append(string2);
                stringBuffer2.append("\t\t\t");
                ++n2;
            }
            stringBuffer.append("\t\t Exception: " + stringBuffer2.toString() + "\n");
            ++n;
        }
        String[] stringArray = this.getOutput();
        if (stringArray != null) {
            stringBuffer.append("\tTest System Output...\n");
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringBuffer.append("\t" + stringArray[n3] + "\n");
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

