/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona;

import java.util.PriorityQueue;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.CoronaException;
import org.eclipse.corona.internal.Activator;
import org.eclipse.corona.server.IApplicationManager;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Application
implements IApplication {
    private static final String EXT_POINT_STARTUP = "org.eclipse.corona.startup";
    private static final String EXT_POINT_APPLICATION = "org.eclipse.core.runtime.applications";
    private static final String OSGI_APPLICATIONS = "osgi.applications";
    private static final String OSGI_APPLICATIONS_STARTLEVEL = "osgi.applications.defaultStartLevel";
    private LogService logService;
    private boolean stopRequest = false;
    private final long STOP_TIMEOUT = 5000L;
    private BundleContext ctxBundle = Activator.getDefault().getBundleContext();
    private IApplicationManager appManager;
    private ServiceTracker srvTrackerAppManager;
    private int startLevel = 5;

    public Application() {
        this.logService = Activator.getDefault().getLogService();
        String string = System.getProperty(OSGI_APPLICATIONS_STARTLEVEL);
        if (string != null) {
            try {
                this.startLevel = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                this.logService.log(2, "invalid application start level: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext iApplicationContext) throws Exception {
        this.logService.log(4, "entering Application.start()");
        this.srvTrackerAppManager = new ServiceTracker(this.ctxBundle, IApplicationManager.class.getName(), null);
        this.srvTrackerAppManager.open();
        this.appManager = (IApplicationManager)this.srvTrackerAppManager.waitForService(0L);
        iApplicationContext.applicationRunning();
        this.startBundles();
        this.startApplications();
        Application application = this;
        synchronized (application) {
            while (!this.stopRequest) {
                this.wait(5000L);
                if (this.appManager.countRunningApplications() == 0) break;
            }
        }
        try {
            this.appManager.stopAllApplications();
        }
        catch (CoronaException coronaException) {
            this.logService.log(1, coronaException.getMessage());
        }
        this.srvTrackerAppManager.close();
        this.logService.log(4, "exiting Application.start()");
        return EXIT_OK;
    }

    private void startBundles() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_STARTUP);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray;
            TreeMap<Integer, IContributor> treeMap = new TreeMap<Integer, IContributor>();
            String string = System.getProperty("osgi.bundles.defaultStartLevel", "5");
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                IExtension iExtension = iConfigurationElement.getDeclaringExtension();
                String string2 = iConfigurationElement.getAttribute("level");
                if (string2 == null) {
                    string2 = string;
                }
                Integer n3 = new Integer(string2);
                IContributor iContributor = iExtension.getContributor();
                treeMap.put(n3, iContributor);
                ++n2;
            }
            for (IContributor iContributor : treeMap.values()) {
                try {
                    Activator.getDefault().startBundle(iContributor.getName());
                }
                catch (Exception exception) {
                    this.logService.log(1, "Unable to start bundle", (Throwable)exception);
                }
            }
        }
    }

    private void startApplications() {
        AppSyntax[] appSyntaxArray;
        this.logService.log(4, "entering: Application.startApplications()");
        String string = System.getProperty(OSGI_APPLICATIONS);
        if (string == null) {
            this.logService.log(3, "'osgi.applications' property not defined");
            return;
        }
        PriorityQueue<AppSyntax> priorityQueue = new PriorityQueue<AppSyntax>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            appSyntaxArray = stringTokenizer.nextToken();
            AppSyntax appSyntax = new AppSyntax();
            appSyntax.setApp((String)appSyntaxArray);
            priorityQueue.add(appSyntax);
        }
        appSyntaxArray = priorityQueue.toArray(new AppSyntax[priorityQueue.size()]);
        this.startApplicationExtensionBundle(appSyntaxArray);
        int n = 0;
        while (n < appSyntaxArray.length) {
            try {
                this.appManager.startApplication(appSyntaxArray[n].getApp());
            }
            catch (CoronaException coronaException) {
                this.logService.log(2, coronaException.getMessage());
            }
            ++n;
        }
        this.logService.log(4, "exiting: Application.startApplications()");
    }

    private void startApplicationExtensionBundle(AppSyntax[] appSyntaxArray) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_APPLICATION);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppSyntax appSyntax;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                IExtension iExtension = iConfigurationElement.getDeclaringExtension();
                String string = iExtension.getUniqueIdentifier();
                boolean bl = false;
                AppSyntax[] appSyntaxArray2 = appSyntaxArray;
                int n3 = appSyntaxArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    appSyntax = appSyntaxArray2[n4];
                    if (appSyntax.getId().equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    try {
                        appSyntax = iExtension.getContributor();
                        Activator.getDefault().startBundle(appSyntax.getName());
                    }
                    catch (Exception exception) {
                        this.logService.log(1, "Unable to create application extenstion", (Throwable)exception);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.logService.log(4, "entering Application.stop()");
        this.stopRequest = true;
        Application application = this;
        synchronized (application) {
            this.notify();
        }
        this.logService.log(4, "exiting Application.stop()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AppSyntax
    implements Comparable<AppSyntax> {
        String app;
        String id;
        int level;

        public AppSyntax() {
            this.level = Application.this.startLevel;
        }

        public void setApp(String string) {
            StringTokenizer stringTokenizer;
            this.app = string;
            if (string.contains("@")) {
                stringTokenizer = new StringTokenizer(string, "@,");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.setLevel(string3);
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append("," + stringTokenizer.nextToken());
                }
                String string4 = stringBuffer.toString();
                this.app = String.valueOf(string2) + string4;
            }
            stringTokenizer = new StringTokenizer(this.app, ",");
            this.id = stringTokenizer.nextToken();
        }

        public void setLevel(String string) {
            try {
                this.level = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                Application.this.logService.log(2, "invalid application start level: " + string);
            }
        }

        public int getLevel() {
            return this.level;
        }

        public String getId() {
            return this.id;
        }

        public String getApp() {
            return this.app;
        }

        @Override
        public int compareTo(AppSyntax appSyntax) {
            int n = 0;
            if (this.level < appSyntax.getLevel()) {
                n = -1;
            }
            if (this.level > appSyntax.getLevel()) {
                n = 1;
            }
            return n;
        }
    }
}

