/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.diagnostic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.diagnostic.DiagnosticException;
import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.diagnostic.IDiagnosticManager;
import org.eclipse.corona.internal.diagnostic.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;

public class DiagnosticManager
implements IDiagnosticManager {
    private LogService logService = Activator.getDefault().getLogService();
    private BundleContext ctxBundle;
    private Document docDiag;
    private StringBuffer manifestEntries = new StringBuffer();

    protected void activate(ComponentContext componentContext) {
        this.ctxBundle = componentContext.getBundleContext();
    }

    public String[] listDiagnosticData() {
        IConfigurationElement[] iConfigurationElementArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.diagnostic.data");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                String string = iConfigurationElement.getAttribute("name");
                arrayList.add(string);
                ++n2;
            }
        }
        try {
            iConfigurationElementArray = this.ctxBundle.getServiceReferences(IDiagnosticData.class.getName(), null);
            if (iConfigurationElementArray != null) {
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IDiagnosticData iDiagnosticData = (IDiagnosticData)this.ctxBundle.getService((ServiceReference)iConfigurationElementArray[n]);
                    arrayList.add(iDiagnosticData.getName());
                    this.ctxBundle.ungetService((ServiceReference)iConfigurationElementArray[n]);
                    ++n;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String dumpData(String string) throws DiagnosticException {
        FileOutputStream fileOutputStream;
        String string2 = "corona_" + Long.toString(System.currentTimeMillis()) + ".dmp";
        File file = this.ctxBundle.getDataFile(string2);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(fileNotFoundException);
            throw diagnosticException;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        this.dumpDataExtensions(string, zipOutputStream);
        this.dumpDataServices(string, zipOutputStream);
        this.createManifest(zipOutputStream);
        try {
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
        return file.getAbsolutePath();
    }

    private void dumpDataExtensions(String string, ZipOutputStream zipOutputStream) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.diagnostic.data");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                String string2 = iConfigurationElement.getAttribute("name");
                String string3 = iConfigurationElement.getAttribute("version");
                boolean bl = true;
                if (!(string == null || string.equals("*") || string.equals("") || string.equals("String") || string2.equals(string))) {
                    bl = false;
                }
                if (bl) {
                    try {
                        IDiagnosticData iDiagnosticData = (IDiagnosticData)iConfigurationElement.createExecutableExtension("class");
                        iDiagnosticData.setName(string2);
                        iDiagnosticData.setVersion(string3);
                        this.dumpDiagnosticData(iDiagnosticData, zipOutputStream);
                        this.addManifestEntry(String.valueOf(string2) + ".version=" + string3);
                    }
                    catch (CoreException coreException) {
                        this.logService.log(1, "Unable to create diag data extension", (Throwable)coreException);
                    }
                    catch (DiagnosticException diagnosticException) {
                        this.logService.log(1, "Unable to capture diag data: " + string, (Throwable)diagnosticException);
                    }
                }
                ++n2;
            }
        }
    }

    private void dumpDataServices(String string, ZipOutputStream zipOutputStream) throws DiagnosticException {
        ServiceReference[] serviceReferenceArray;
        if (string == null) {
            string = "*";
        }
        if (string.equals("")) {
            string = "*";
        }
        if (string.equals("String")) {
            string = "*";
        }
        try {
            String string2 = "(name=" + string + ")";
            serviceReferenceArray = this.ctxBundle.getServiceReferences(IDiagnosticData.class.getName(), string2);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to get list of IDiagnosticData component services");
            diagnosticException.initCause(invalidSyntaxException);
            throw diagnosticException;
        }
        int n = 0;
        while (serviceReferenceArray != null && n < serviceReferenceArray.length) {
            ServiceReference serviceReference = serviceReferenceArray[n];
            IDiagnosticData iDiagnosticData = (IDiagnosticData)this.ctxBundle.getService(serviceReference);
            this.dumpDiagnosticData(iDiagnosticData, zipOutputStream);
            String[] stringArray = serviceReference.getPropertyKeys();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                if (!(string3.equals("service.id") || string3.equals("component.id") || string3.equals("objectClass"))) {
                    Object object;
                    Object object2 = serviceReference.getProperty(string3);
                    String string4 = null;
                    if (object2 instanceof String[]) {
                        object = (String[])object2;
                        string4 = object[0];
                        int n3 = 1;
                        while (n3 < ((String[])object).length) {
                            string4 = String.valueOf(string4) + "," + object[n3];
                            ++n3;
                        }
                    } else {
                        string4 = object2.toString();
                    }
                    object = String.valueOf(iDiagnosticData.getName()) + "." + string3;
                    this.addManifestEntry(String.valueOf(object) + ": " + string4);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void addManifestEntry(String string) {
        this.manifestEntries.append(String.valueOf(string) + "\n");
    }

    private void createManifest(ZipOutputStream zipOutputStream) throws DiagnosticException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
        PrintStream printStream = new PrintStream(zipOutputStream);
        printStream.println("Manifest-Version: 1.0");
        printStream.println("Diagnostic-ManifestVersion: 1.0.0");
        printStream.println("Diagnostic-Version: 1.0.0");
        printStream.println("Diagnostic-Vendor: Eclipse.org");
        printStream.println(this.manifestEntries.toString());
        try {
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
    }

    private void dumpDiagnosticData(IDiagnosticData iDiagnosticData, ZipOutputStream zipOutputStream) throws DiagnosticException {
        iDiagnosticData.capture();
        ZipEntry zipEntry = new ZipEntry(String.valueOf(iDiagnosticData.getName()) + "." + iDiagnosticData.getType());
        try {
            zipOutputStream.putNextEntry(zipEntry);
            iDiagnosticData.save(zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            DiagnosticException diagnosticException = new DiagnosticException("Unable to process diagnostic dump file");
            diagnosticException.initCause(iOException);
            throw diagnosticException;
        }
    }
}

