/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class LoggedException
extends Throwable
implements Cloneable {
    private static final long serialVersionUID = -7432693545895678645L;
    String exceptionClassName;
    String message;
    String stackTrace;
    LoggedException nestedException;
    static /* synthetic */ Class class$0;

    public LoggedException(Throwable t) {
        if (t.getMessage() != null) {
            this.message = new String(t.getMessage().toCharArray());
        }
        if (t instanceof LoggedException) {
            LoggedException lex = (LoggedException)t;
            this.exceptionClassName = lex.exceptionClassName;
            this.stackTrace = new String(lex.stackTrace.toCharArray());
        } else {
            this.exceptionClassName = t.getClass().getName();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream s = new PrintStream(baos);
            t.printStackTrace(s);
            s.close();
            this.stackTrace = baos.toString();
        }
        this.exceptionClassName = new String(this.exceptionClassName.toCharArray());
        Method[] methods = t.getClass().getMethods();
        int size = methods.length;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> throwable = clazz;
        int i = 0;
        while (i < size) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && throwable.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                try {
                    Throwable nested = (Throwable)method.invoke((Object)t, null);
                    if (nested != null && nested != t) {
                        this.nestedException = new LoggedException(nested);
                        break;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++i;
        }
    }

    public Throwable fillInStackTrace() {
        return this;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getNestedException() {
        return this.nestedException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this.stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter w) {
        PrintWriter printWriter = w;
        synchronized (printWriter) {
            w.println(this.stackTrace);
        }
    }

    public String toString() {
        if (this.message == null) {
            return this.exceptionClassName;
        }
        int length = this.exceptionClassName.length() + this.message.length() + 2;
        return new StringBuffer(length).append(this.exceptionClassName).append(": ").append(this.message).toString();
    }
}

