/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diagnostic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.internal.diagnostic.Activator;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractDiagnosticData
implements IDiagnosticData {
    public static final String ATTR_COUNT = "count";
    private transient LogService logService = Activator.getDefault().getLogService();
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String version;
    protected Hashtable<String, Object> properties;
    protected Document docDiag;
    protected Element rootDiag;

    protected AbstractDiagnosticData() {
        this.init();
    }

    private void init() {
        this.properties = new Hashtable();
    }

    protected void initComponent(Dictionary dictionary) {
        Object v = dictionary.get("name");
        if (v instanceof String[]) {
            this.name = ((String[])v)[0];
        }
        if ((v = dictionary.get("version")) instanceof String[]) {
            this.version = ((String[])v)[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void capture() {
        this.init();
        this.addProperty("timestamp", new Long(System.currentTimeMillis()));
    }

    public void addProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Element createElementDiagnostic() {
        Element element = this.docDiag.createElement(this.getName());
        element.setAttribute("version", this.getVersion());
        Element element2 = this.docDiag.createElement("PropertyList");
        element.appendChild(element2);
        Enumeration<String> enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = this.properties.get(string);
            Element element3 = this.createElementProperty(this.docDiag, string, object);
            element2.appendChild(element3);
        }
        return element;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.docDiag);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            this.logService.log(2, "Unable to save diagnostic data", (Throwable)exception);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        throw new IOException("Not Yet Implemented!");
    }

    protected void cleanUp() throws IOException {
        this.docDiag = null;
    }

    protected void initXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.docDiag = documentBuilder.newDocument();
        this.rootDiag = this.docDiag.createElement("CoronaDiagnostics" + this.getName());
        this.rootDiag.setAttribute("version", this.getVersion());
        this.docDiag.appendChild(this.rootDiag);
    }

    protected Element createElement(String string, String string2) {
        Element element = this.docDiag.createElement(string);
        Text text = this.docDiag.createTextNode(string2.toString());
        element.appendChild(text);
        return element;
    }

    protected Element createElementProperty(Document document, String string, Object object) {
        Object object2;
        int n;
        Element element = document.createElement("Property");
        element.setAttribute("name", string);
        String string2 = "unknown";
        if (object instanceof String) {
            string2 = "string";
        } else if (object instanceof Integer) {
            string2 = "int";
        } else if (object instanceof Long) {
            string2 = "long";
        }
        if (string.equals("objectClass") && (n = 0) < ((String[])(object2 = (String[])object)).length) {
            return this.createElementProperty(document, "service.class", object2[n]);
        }
        element.setAttribute("type", string2);
        object2 = document.createTextNode(object.toString());
        element.appendChild((Node)object2);
        return element;
    }
}

