/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.diagnostic.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.diagnostic.AbstractDiagnosticData;
import org.eclipse.corona.diagnostic.data.EventData;
import org.eclipse.corona.internal.diagnostic.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;
import org.w3c.dom.Element;

public class EventDiagnosticData
extends AbstractDiagnosticData
implements Serializable,
EventHandler {
    private LogService logService = Activator.getDefault().getLogService();
    private static final long serialVersionUID = 1L;
    private transient BundleContext ctxBundle;
    private transient ServiceRegistration srvRegEventHandler;
    private transient int qSize = 200;
    private transient EventData[] qTempData;
    private transient int qTempHead = 0;
    private transient int qTempTail = 0;
    private EventData[] qCaptureData;
    private transient int qCaptureHead = 0;
    private transient int qCaptureTail = 0;
    private static final String ATTR_QSIZE = "qsize";

    protected void activate(ComponentContext componentContext) {
        Object object;
        this.ctxBundle = componentContext.getBundleContext();
        super.initComponent(componentContext.getProperties());
        Object v = componentContext.getProperties().get(ATTR_QSIZE);
        if (v instanceof String[] && (object = ((String[])v)[0]) != null) {
            this.qSize = Integer.parseInt((String)object);
        }
        this.qTempData = new EventData[this.qSize];
        try {
            object = new Hashtable();
            String[] stringArray = new String[]{"*"};
            ((Dictionary)object).put("event.topics", stringArray);
            this.srvRegEventHandler = this.ctxBundle.registerService(EventHandler.class.getName(), (Object)this, (Dictionary)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.srvRegEventHandler.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture() {
        EventData[] eventDataArray = this.qTempData;
        synchronized (this.qTempData) {
            this.qCaptureData = this.qTempData;
            this.qCaptureHead = this.qTempHead;
            this.qCaptureTail = this.qTempTail;
            this.qTempData = new EventData[this.qSize];
            this.qTempHead = 0;
            this.qTempTail = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.createXML();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        super.save(outputStream);
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        EventData eventData = new EventData(event);
        EventData[] eventDataArray = this.qTempData;
        synchronized (this.qTempData) {
            this.qTempData[this.qTempHead++] = eventData;
            this.qTempHead %= this.qSize;
            if (this.qTempHead == this.qTempTail) {
                ++this.qTempTail;
                this.qTempTail %= this.qSize;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private int qCaptureSize() {
        int n = 0;
        n = this.qTempHead > this.qTempTail ? this.qTempHead - this.qTempTail : this.qSize - this.qTempHead + this.qTempTail;
        return n;
    }

    private void createXML() throws ParserConfigurationException {
        super.initXmlDocument();
        Element element = super.createElementDiagnostic();
        int n = this.qCaptureHead >= this.qCaptureTail ? this.qCaptureHead - this.qCaptureTail : this.qSize - this.qCaptureHead + this.qCaptureTail - 1;
        this.logService.log(4, "...diagnostic event capture count:" + n);
        element.setAttribute("count", Integer.toString(n));
        int n2 = 0;
        while (n2 < n) {
            EventData eventData = this.qCaptureData[n2];
            Event event = eventData.getEvent();
            Element element2 = this.docDiag.createElement("Event");
            element2.setAttribute("topic", event.getTopic());
            element2.setAttribute("timestamp", Long.toString(eventData.getTimestamp()));
            element.appendChild(element2);
            Element element3 = this.docDiag.createElement("PropertyList");
            element2.appendChild(element3);
            String[] stringArray = event.getPropertyNames();
            int n3 = 0;
            while (n3 < stringArray.length) {
                Object object = event.getProperty(stringArray[n3]);
                Element element4 = this.createElementProperty(this.docDiag, stringArray[n3], object);
                element3.appendChild(element4);
                ++n3;
            }
            ++n2;
        }
        this.rootDiag.appendChild(element);
    }

    public String getType() {
        return "xml";
    }
}

