/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;

public class ParallelReader
extends IndexReader {
    private List readers = new ArrayList();
    private SortedMap fieldToReader = new TreeMap();
    private List storedFieldReaders = new ArrayList();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        super(null);
    }

    public void add(IndexReader reader) throws IOException {
        this.add(reader, false);
    }

    public void add(IndexReader reader, boolean ignoreStoredFields) throws IOException {
        if (this.readers.size() == 0) {
            this.maxDoc = reader.maxDoc();
            this.numDocs = reader.numDocs();
            this.hasDeletions = reader.hasDeletions();
        }
        if (reader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        if (reader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + reader.numDocs());
        }
        Iterator i = reader.getFieldNames(IndexReader.FieldOption.ALL).iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            if (this.fieldToReader.get(field) != null) continue;
            this.fieldToReader.put(field, reader);
        }
        if (!ignoreStoredFields) {
            this.storedFieldReaders.add(reader);
        }
        this.readers.add(reader);
    }

    public int numDocs() {
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return ((IndexReader)this.readers.get(0)).isDeleted(n);
        }
        return false;
    }

    protected void doDelete(int n) throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).doDelete(n);
        }
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).doUndeleteAll();
        }
        this.hasDeletions = false;
    }

    public Document document(int n) throws IOException {
        Document result = new Document();
        for (int i = 0; i < this.storedFieldReaders.size(); ++i) {
            IndexReader reader = (IndexReader)this.storedFieldReaders.get(i);
            Enumeration fields = reader.document(n).fields();
            while (fields.hasMoreElements()) {
                result.add((Field)fields.nextElement());
            }
        }
        return result;
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        ArrayList<TermFreqVector> results = new ArrayList<TermFreqVector>();
        Iterator i = this.fieldToReader.entrySet().iterator();
        while (i.hasNext()) {
            String field;
            Map.Entry e = i.next();
            IndexReader reader = (IndexReader)e.getKey();
            TermFreqVector vector = reader.getTermFreqVector(n, field = (String)e.getValue());
            if (vector == null) continue;
            results.add(vector);
        }
        return results.toArray(new TermFreqVector[results.size()]);
    }

    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        return ((IndexReader)this.fieldToReader.get(field)).getTermFreqVector(n, field);
    }

    public boolean hasNorms(String field) throws IOException {
        return ((IndexReader)this.fieldToReader.get(field)).hasNorms(field);
    }

    public byte[] norms(String field) throws IOException {
        return ((IndexReader)this.fieldToReader.get(field)).norms(field);
    }

    public void norms(String field, byte[] result, int offset) throws IOException {
        ((IndexReader)this.fieldToReader.get(field)).norms(field, result, offset);
    }

    protected void doSetNorm(int n, String field, byte value) throws IOException {
        ((IndexReader)this.fieldToReader.get(field)).doSetNorm(n, field, value);
    }

    public TermEnum terms() throws IOException {
        return new ParallelTermEnum();
    }

    public TermEnum terms(Term term) throws IOException {
        return new ParallelTermEnum(term);
    }

    public int docFreq(Term term) throws IOException {
        return ((IndexReader)this.fieldToReader.get(term.field())).docFreq(term);
    }

    public TermDocs termDocs(Term term) throws IOException {
        return new ParallelTermDocs(term);
    }

    public TermDocs termDocs() throws IOException {
        return new ParallelTermDocs();
    }

    public TermPositions termPositions(Term term) throws IOException {
        return new ParallelTermPositions(term);
    }

    public TermPositions termPositions() throws IOException {
        return new ParallelTermPositions();
    }

    protected void doCommit() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).commit();
        }
    }

    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).close();
        }
    }

    public Collection getFieldNames() throws IOException {
        return this.fieldToReader.keySet();
    }

    public Collection getFieldNames(boolean indexed) throws IOException {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getFieldNames(indexed);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    public Collection getIndexedFieldNames(Field.TermVector tvSpec) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getIndexedFieldNames(tvSpec);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            this.seek(term);
        }

        public int doc() {
            return this.termDocs.doc();
        }

        public int freq() {
            return this.termDocs.freq();
        }

        public void seek(Term term) throws IOException {
            this.termDocs = ((IndexReader)ParallelReader.this.fieldToReader.get(term.field())).termDocs(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        public boolean next() throws IOException {
            return this.termDocs.next();
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            return this.termDocs.read(docs, freqs);
        }

        public boolean skipTo(int target) throws IOException {
            return this.termDocs.skipTo(target);
        }

        public void close() throws IOException {
            this.termDocs.close();
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(term);
        }

        public boolean next() throws IOException {
            if (this.field == null) {
                return false;
            }
            boolean next = this.termEnum.next();
            if (next && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            this.field = ParallelReader.this.fieldToReader.tailMap(this.field).firstKey();
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
                return true;
            }
            return false;
        }

        public Term term() {
            return this.termEnum.term();
        }

        public int docFreq() {
            return this.termEnum.docFreq();
        }

        public void close() throws IOException {
            this.termEnum.close();
        }
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        public void seek(Term term) throws IOException {
            this.termDocs = ((IndexReader)ParallelReader.this.fieldToReader.get(term.field())).termPositions(term);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }
    }
}

