/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diag.data.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.diagnostic.AbstractDiagnosticData;
import org.w3c.dom.Element;

public class SystemDiagnosticData
extends AbstractDiagnosticData
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void capture() {
        Object object;
        super.capture();
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = System.getProperty((String)object);
            this.addProperty((String)object, string);
        }
        object = Runtime.getRuntime();
        this.addProperty("runtime.max.memory", new Long(((Runtime)object).maxMemory()));
        this.addProperty("runtime.free.memory", new Long(((Runtime)object).freeMemory()));
        this.addProperty("runtime.total.memory", new Long(((Runtime)object).totalMemory()));
        this.addProperty("runtime.available.processors", new Integer(((Runtime)object).availableProcessors()));
    }

    private void createXML() throws ParserConfigurationException {
        super.initXmlDocument();
        Element element = super.createElementDiagnostic();
        this.rootDiag.appendChild(element);
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.createXML();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        super.save(outputStream);
        this.cleanUp();
    }

    public String getType() {
        return "xml";
    }
}

