/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public abstract class AbstractDiscoveryContainerAdapter
extends AbstractContainer
implements IDiscoveryContainerAdapter,
IContainer {
    protected final Set allServiceListeners;
    private DiscoveryContainerConfig config;
    protected final Map serviceListeners;
    protected final String servicesNamespaceName;
    protected final Collection serviceTypeListeners;

    public AbstractDiscoveryContainerAdapter(String aNamespaceName, DiscoveryContainerConfig aConfig) {
        this.servicesNamespaceName = aNamespaceName;
        Assert.isNotNull((Object)this.servicesNamespaceName);
        this.config = aConfig;
        Assert.isNotNull((Object)this.config);
        this.serviceTypeListeners = Collections.synchronizedSet(new HashSet());
        this.serviceListeners = Collections.synchronizedMap(new HashMap());
        this.allServiceListeners = Collections.synchronizedSet(new HashSet());
    }

    public void addServiceListener(IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.allServiceListeners.add(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(IServiceTypeID aType, IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        Assert.isNotNull((Object)aType);
        Map map = this.serviceListeners;
        synchronized (map) {
            Set<IServiceListener> v = (Set<IServiceListener>)this.serviceListeners.get(aType);
            if (v == null) {
                v = Collections.synchronizedSet(new HashSet());
                this.serviceListeners.put(aType, v);
            }
            v.add(aListener);
        }
    }

    public void addServiceTypeListener(IServiceTypeListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.serviceTypeListeners.add(aListener);
    }

    protected void clearListeners() {
        this.serviceListeners.clear();
        this.serviceTypeListeners.clear();
        this.allServiceListeners.clear();
    }

    public void dispose() {
        this.disconnect();
        this.clearListeners();
        this.config = null;
        super.dispose();
    }

    protected void fireServiceDiscovered(IServiceEvent aServiceEvent) {
        Assert.isNotNull((Object)aServiceEvent);
        Collection listeners = this.getListeners(aServiceEvent.getServiceInfo().getServiceID().getServiceTypeID());
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                IServiceListener l = (IServiceListener)i.next();
                l.serviceDiscovered(aServiceEvent);
                Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceDiscovered", (String)aServiceEvent.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServiceTypeDiscovered(IServiceTypeEvent aServiceTypeEvent) {
        Assert.isNotNull((Object)aServiceTypeEvent);
        ArrayList notify = null;
        Collection collection = this.serviceTypeListeners;
        synchronized (collection) {
            notify = new ArrayList(this.serviceTypeListeners);
        }
        Iterator i = notify.iterator();
        while (i.hasNext()) {
            IServiceTypeListener l = (IServiceTypeListener)i.next();
            l.serviceTypeDiscovered(aServiceTypeEvent);
            Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceTypeDiscovered", (String)aServiceTypeEvent.toString());
        }
    }

    protected void fireServiceUndiscovered(IServiceEvent aServiceEvent) {
        Assert.isNotNull((Object)aServiceEvent);
        Collection listeners = this.getListeners(aServiceEvent.getServiceInfo().getServiceID().getServiceTypeID());
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                IServiceListener l = (IServiceListener)i.next();
                l.serviceUndiscovered(aServiceEvent);
                Trace.trace((String)"org.eclipse.ecf.discovery", (String)"org.eclipse.ecf.discovery/debug/methods/tracing", this.getClass(), (String)"fireServiceUndiscovered", (String)aServiceEvent.toString());
            }
        }
    }

    protected DiscoveryContainerConfig getConfig() {
        return this.config;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(this.servicesNamespaceName);
    }

    public ID getID() {
        if (this.config != null) {
            return this.config.getID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getListeners(IServiceTypeID aServiceType) {
        Assert.isNotNull((Object)aServiceType);
        HashSet listeners = new HashSet();
        Object object = this.serviceListeners;
        synchronized (object) {
            Collection collection = (Collection)this.serviceListeners.get(aServiceType);
            if (collection != null) {
                listeners.addAll(collection);
            }
        }
        object = this.allServiceListeners;
        synchronized (object) {
            listeners.addAll(this.allServiceListeners);
        }
        return Collections.unmodifiableCollection(listeners);
    }

    public Namespace getServicesNamespace() {
        return IDFactory.getDefault().getNamespaceByName(this.servicesNamespaceName);
    }

    public void removeServiceListener(IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.allServiceListeners.remove(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(IServiceTypeID aType, IServiceListener aListener) {
        Assert.isNotNull((Object)aListener);
        Assert.isNotNull((Object)aType);
        Map map = this.serviceListeners;
        synchronized (map) {
            Collection v = (Collection)this.serviceListeners.get(aType);
            if (v != null) {
                v.remove(aListener);
            }
        }
    }

    public void removeServiceTypeListener(IServiceTypeListener aListener) {
        Assert.isNotNull((Object)aListener);
        this.serviceTypeListeners.remove(aListener);
    }
}

