/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.container.database;

import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.corona.internal.container.database.Activator;
import org.eclipse.corona.server.AbstractServerApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Application
extends AbstractServerApplication
implements Runnable {
    private LogService logService = Activator.getDefault().getLogService();
    private String derbyHome;
    private static final String SERVER_NAME = "CoronaDatabase";
    private static final String PROPERTY_DERBY_HOME = "derby.system.home";
    private static final String PROPERTY_DERBY_PORT = "derby.drda.portNumber";
    private NetworkServerControl derbyServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext iApplicationContext) throws Exception {
        this.logService.log(4, "entering Application.start()");
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        Object object = super.start(bundleContext, iApplicationContext, SERVER_NAME);
        try {
            this.derbyServer = new NetworkServerControl();
            this.derbyServer.start(null);
            int n = 0;
            while (n < 10) {
                Thread.sleep(1000L);
                boolean bl = false;
                try {
                    this.derbyServer.ping();
                    bl = true;
                }
                catch (Exception exception) {}
                if (!bl) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logService.log(1, "Unable to start Corona Database Server", (Throwable)exception);
            object = new Integer(-1);
        }
        iApplicationContext.applicationRunning();
        NetworkServerControl networkServerControl = this.derbyServer;
        synchronized (networkServerControl) {
            this.derbyServer.wait();
        }
        try {
            this.derbyServer.shutdown();
        }
        catch (Exception exception) {
            this.logService.log(1, "failed to properly shutdown Corona Database Server", (Throwable)exception);
            object = new Integer(-2);
        }
        this.logService.log(4, "exiting Application.start()");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NetworkServerControl networkServerControl = this.derbyServer;
        synchronized (networkServerControl) {
            this.derbyServer.notify();
        }
        super.stop();
    }

    protected void initialize() {
        super.initialize();
        this.derbyHome = System.getProperty(PROPERTY_DERBY_HOME);
        if (this.derbyHome == null) {
            this.derbyHome = this.getWorkingDirectory().getAbsolutePath();
        }
        System.setProperty(PROPERTY_DERBY_HOME, this.derbyHome);
        String string = this.getProperty("port");
        if (string != null) {
            System.setProperty(PROPERTY_DERBY_PORT, string);
        }
    }

    public void run() {
    }
}

