/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diag.data.bundles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.corona.diagnostic.AbstractDiagnosticData;
import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.diagnostic.data.BundleData;
import org.eclipse.corona.internal.diag.data.bundles.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagnosticData
extends AbstractDiagnosticData
implements IDiagnosticData {
    private transient BundleContext ctxBundle = Activator.getDefault().getBundleContext();
    private BundleData[] bundleData;

    public String getType() {
        return "xml";
    }

    public void capture() {
        super.capture();
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.createXML();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        super.save(outputStream);
        this.cleanUp();
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    private void createXML() throws ParserConfigurationException {
        super.initXmlDocument();
        Element element = super.createElementDiagnostic();
        Bundle[] bundleArray = this.ctxBundle.getBundles();
        element.setAttribute("count", Integer.toString(bundleArray.length));
        this.bundleData = new BundleData[bundleArray.length];
        int n = 0;
        while (n < bundleArray.length) {
            Element element2;
            Object object;
            int n2;
            String[] stringArray;
            Element element3;
            Object object2;
            Object object3;
            this.bundleData[n] = new BundleData(bundleArray[n]);
            Bundle bundle = bundleArray[n];
            Element element4 = this.docDiag.createElement("Bundle");
            element4.setAttribute("id", Long.toString(bundle.getBundleId()));
            element4.setAttribute("state", Integer.toString(bundle.getState()));
            element.appendChild(element4);
            Element element5 = this.docDiag.createElement("PropertyList");
            element4.appendChild(element5);
            Dictionary dictionary = bundle.getHeaders();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object2 = (String)dictionary.get(object3);
                Element element6 = this.createElementProperty(this.docDiag, (String)object3, object2);
                element5.appendChild(element6);
            }
            object3 = bundle.getRegisteredServices();
            if (object3 != null) {
                object2 = this.docDiag.createElement("RegisteredServices");
                element4.appendChild((Node)object2);
                int n3 = 0;
                while (n3 < ((ServiceReference[])object3).length) {
                    element3 = this.docDiag.createElement("Service");
                    object2.appendChild(element3);
                    element5 = this.docDiag.createElement("PropertyList");
                    element3.appendChild(element5);
                    stringArray = object3[n3].getPropertyKeys();
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        object = object3[n3].getProperty(stringArray[n2]);
                        element2 = this.createElementProperty(this.docDiag, stringArray[n2], object);
                        element5.appendChild(element2);
                        ++n2;
                    }
                    ++n3;
                }
            }
            if ((object3 = bundle.getServicesInUse()) != null) {
                object2 = this.docDiag.createElement("ServicesInUse");
                element4.appendChild((Node)object2);
                int n4 = 0;
                while (n4 < ((ServiceReference[])object3).length) {
                    element3 = this.docDiag.createElement("Service");
                    object2.appendChild(element3);
                    element5 = this.docDiag.createElement("PropertyList");
                    element3.appendChild(element5);
                    stringArray = object3[n4].getPropertyKeys();
                    n2 = 0;
                    while (n2 < stringArray.length) {
                        object = object3[n4].getProperty(stringArray[n2]);
                        element2 = this.createElementProperty(this.docDiag, stringArray[n2], object);
                        element5.appendChild(element2);
                        ++n2;
                    }
                    ++n4;
                }
            }
            ++n;
        }
        this.rootDiag.appendChild(element);
    }
}

