/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.wireadmin;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.wireadmin.Activator;
import org.eclipse.equinox.internal.wireadmin.EventDispatcher;
import org.eclipse.equinox.internal.wireadmin.NotificationEvent;
import org.eclipse.equinox.internal.wireadmin.WireImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.wireadmin.Consumer;
import org.osgi.service.wireadmin.Producer;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdmin;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;

class WireAdminImpl
implements WireAdmin,
ManagedServiceFactory,
ServiceListener {
    private EventDispatcher evtDisp;
    private static final String PID_PREFIX = "WA_GENERATED_PID_";
    private static final String FACTORY_PID = "equinox.wireadmin.fpid";
    private BundleContext bc;
    ConfigurationAdmin cm;
    private Hashtable wires;
    private ServiceRegistration regWireAdmin;
    private ServiceRegistration regManagedFactory;
    private Vector waitForUpdate = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    WireAdminImpl(BundleContext bc, ConfigurationAdmin cm) {
        Class<?> clazz;
        this.bc = bc;
        this.cm = cm;
        this.wires = new Hashtable();
        this.evtDisp = new EventDispatcher(bc, this);
        Hashtable<String, String> props = new Hashtable<String, String>(2, 1.0f);
        props.put("service.pid", FACTORY_PID);
        props.put("service.factoryPid", FACTORY_PID);
        if (cm != null) {
            try {
                Configuration[] all = cm.listConfigurations("(service.factoryPid=equinox.wireadmin.fpid)");
                if (all != null) {
                    int i = 0;
                    while (i < all.length) {
                        Dictionary properties = all[i].getProperties();
                        String pid = (String)properties.get("wireadmin.pid");
                        if (pid == null) {
                            pid = all[i].getPid();
                            properties.put("wireadmin.pid", pid);
                        }
                        WireImpl wire = new WireImpl(bc, this, properties);
                        this.wires.put(pid, wire);
                        wire.start();
                        ++i;
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.regManagedFactory = bc.registerService(clazz.getName(), (Object)this, props);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.wireadmin.WireAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.regWireAdmin = bc.registerService(clazz2.getName(), (Object)this, props);
    }

    public Wire createWire(String producerPID, String consumerPID, Dictionary props) {
        return this.createWire(producerPID, consumerPID, props, null);
    }

    private Wire createWire(String producerPID, String consumerPID, Dictionary props, String pid) {
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10004, String.valueOf(producerPID) + " / " + consumerPID + " / =" + props, null, false);
        }
        if (pid == null && (producerPID == null || consumerPID == null)) {
            throw new IllegalArgumentException("PIDs can not be null");
        }
        if (props == null) {
            props = new Hashtable<String, String>(7, 1.0f);
        } else if (WireAdminImpl.caseVariants(props)) {
            throw new IllegalArgumentException("Illegal wire properties. Two or more keys with the same value, or incorrect key type!");
        }
        if (pid == null) {
            ((Dictionary)props).put("wireadmin.producer.pid", producerPID);
            ((Dictionary)props).put("wireadmin.consumer.pid", consumerPID);
        }
        WireImpl wire = null;
        if (pid != null) {
            wire = new WireImpl(this.bc, this, props);
            this.wires.put(pid, wire);
            wire.start();
        } else if (this.cm != null) {
            try {
                Configuration config = this.cm.createFactoryConfiguration(FACTORY_PID);
                ((Dictionary)props).put("wireadmin.pid", config.getPid());
                wire = new WireImpl(this.bc, this, props);
                this.wires.put(config.getPid(), wire);
                wire.start();
                this.waitForUpdate.addElement(wire);
                config.update(props);
            }
            catch (IOException ioe) {
                if (Activator.LOG_DEBUG) {
                    Activator.log.debug(0, 10005, null, (Throwable)ioe, false);
                }
            }
        } else {
            String wirePID = WireAdminImpl.getNextPID();
            ((Dictionary)props).put("wireadmin.pid", wirePID);
            ((Dictionary)props).put("service.factoryPid", FACTORY_PID);
            wire = new WireImpl(this.bc, this, props);
            this.wires.put(wirePID, wire);
            wire.start();
            Activator.log.info("[WireAdmin]: CM not available! The created wire from Producer=" + producerPID + " and Consumer=" + consumerPID + " won't be presistently stored!");
        }
        this.notifyListeners(wire, 4, null);
        return wire;
    }

    public void updateWire(Wire wire, Dictionary properties) {
        WireImpl wireImpl = (WireImpl)wire;
        if (wireImpl == null || !wireImpl.isValid) {
            return;
        }
        if (properties == null) {
            properties = new Hashtable(7, 1.0f);
        }
        Enumeration en = ((Dictionary)properties).keys();
        while (en.hasMoreElements()) {
            if (en.nextElement() instanceof String) continue;
            throw new IllegalArgumentException("Illegal keys, must be String type");
        }
        if (WireAdminImpl.caseVariants(properties)) {
            if (Activator.LOG_DEBUG) {
                Activator.log.debug(0, 10006, null, null, false);
            }
            throw new IllegalArgumentException("Found case variants in properties' keys");
        }
        String wirePID = (String)wire.getProperties().get("wireadmin.pid");
        if (this.cm != null && wirePID.charAt(0) != 'W') {
            wireImpl.setProperties(properties);
            this.wires.put(wirePID, wire);
            this.waitForUpdate.addElement(wire);
            try {
                Configuration conf = this.cm.getConfiguration(wirePID);
                conf.update(properties);
            }
            catch (IOException ioe) {
                Activator.log.error("[WireAdmin]: I/O error updating configuration!", (Throwable)ioe);
            }
        } else {
            this.wires.remove(wirePID);
            wireImpl.setProperties(properties);
            this.wires.put(wirePID, wire);
        }
    }

    public void deleteWire(Wire wire) {
        WireImpl wireImpl = (WireImpl)wire;
        try {
            if (this.cm != null) {
                Configuration current = this.cm.getConfiguration(wireImpl.getWirePID());
                if (current != null) {
                    current.delete();
                }
            } else {
                this.disconnectWire(wireImpl);
            }
        }
        catch (IOException ioe) {
            Activator.log.error("[WireAdmin]: I/O error getting a configuration!", (Throwable)ioe);
        }
    }

    private Wire[] getWires(String pid, boolean isProducer) throws InvalidSyntaxException {
        if (isProducer) {
            return this.getWires("(wireadmin.producer.pid=" + WireImpl.escapeSpecialCharacters(pid) + ')');
        }
        return this.getWires("(wireadmin.consumer.pid=" + WireImpl.escapeSpecialCharacters(pid) + ')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wire[] getWires(String filterString) throws InvalidSyntaxException {
        if (filterString == null) {
            return this.getAllWires();
        }
        Filter filter = this.bc.createFilter(filterString);
        if (filter == null) {
            return this.getAllWires();
        }
        Vector<Wire> tmp = new Vector<Wire>();
        Hashtable hashtable = this.wires;
        synchronized (hashtable) {
            Enumeration en = this.wires.elements();
            while (en.hasMoreElements()) {
                Wire wire = (Wire)en.nextElement();
                Dictionary wireProps = wire.getProperties();
                if (!wire.isValid() || !filter.match(wireProps)) continue;
                tmp.addElement(wire);
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        Object[] allWires = new Wire[tmp.size()];
        tmp.copyInto(allWires);
        return allWires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wire[] getAllWires() {
        if (this.wires.isEmpty()) {
            return null;
        }
        Vector<Wire> tmp = new Vector<Wire>();
        Hashtable hashtable = this.wires;
        synchronized (hashtable) {
            Enumeration en = this.wires.elements();
            while (en.hasMoreElements()) {
                Wire wire = (Wire)en.nextElement();
                if (!wire.isValid()) continue;
                tmp.addElement(wire);
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        Object[] allWires = new Wire[tmp.size()];
        tmp.copyInto(allWires);
        return allWires;
    }

    private void disconnectWire(WireImpl wire) {
        if (this.wires == null) {
            return;
        }
        Object result = this.wires.remove(wire.getWirePID());
        if (result != null) {
            boolean wasConnected = wire.isConnected();
            wire.stop();
            if (wasConnected) {
                this.notifyListeners(wire, 64, null);
            }
            this.notifyListeners(wire, 16, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Wire[] getConnected(String key, String value) {
        if (key == null || value == null || this.wires.isEmpty()) {
            return null;
        }
        Vector<WireImpl> connected = new Vector<WireImpl>();
        Hashtable hashtable = this.wires;
        synchronized (hashtable) {
            Enumeration en = this.wires.elements();
            while (en.hasMoreElements()) {
                WireImpl w = (WireImpl)en.nextElement();
                if (!w.isValid() || !w.isConnected() || !value.equals(w.getProperties().get(key))) continue;
                connected.addElement(w);
            }
        }
        if (connected.isEmpty()) {
            return null;
        }
        Object[] cw = new Wire[connected.size()];
        connected.copyInto(cw);
        return cw;
    }

    public void deleted(String pid) {
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10007, pid, null, false);
        }
        if (this.wires == null) {
            return;
        }
        WireImpl wire = (WireImpl)this.wires.get(pid);
        this.disconnectWire(wire);
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10008, null, null, false);
        }
    }

    public String getName() {
        return "WireAdmin Configuration Factory";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        String consumerPID;
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10009, pid, null, false);
            Activator.log.debug("[WireAdmin]:  " + properties, null);
        }
        if ((consumerPID = (String)properties.get("wireadmin.consumer.pid")) == null) {
            throw new ConfigurationException("wireadmin.consumer.pid", "is not provided");
        }
        String producerPID = (String)properties.get("wireadmin.producer.pid");
        if (producerPID == null) {
            throw new ConfigurationException("wireadmin.producer.pid", "is not provided");
        }
        properties.put("wireadmin.pid", pid);
        if (this.wires == null) {
            return;
        }
        WireImpl wire = (WireImpl)this.wires.get(pid);
        if (wire != null) {
            if (this.waitForUpdate.contains(wire)) {
                this.waitForUpdate.removeElement(wire);
            } else {
                if (Activator.LOG_DEBUG) {
                    Activator.log.debug(0, 10011, wire.toString(), null, false);
                }
                wire.setProperties(properties);
            }
        } else {
            this.createWire(producerPID, consumerPID, properties, pid);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        int type = event.getType();
        ServiceReference ref = event.getServiceReference();
        if (type == 4) {
            this.evtDisp.removeListener(ref);
            return;
        }
        Object service = this.bc.getService(ref);
        if (type == 1) {
            int i;
            boolean doNotify;
            Wire[] wires;
            if (service instanceof WireAdminListener) {
                this.evtDisp.addListener(ref, this.bc.getService(ref));
            }
            if (service instanceof Producer) {
                wires = null;
                try {
                    wires = this.getWires((String)ref.getProperty("service.pid"), true);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
                doNotify = true;
                if (wires != null) {
                    i = 0;
                    while (i < wires.length) {
                        if (((WireImpl)wires[i]).consumerRef != null) {
                            doNotify = false;
                        }
                        ++i;
                    }
                }
                if (doNotify) {
                    this.notifyConsumerProducer(new NotificationEvent((Producer)service, null, null, null));
                }
            }
            if (service instanceof Consumer) {
                wires = null;
                try {
                    wires = this.getWires((String)ref.getProperty("service.pid"), false);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
                doNotify = true;
                if (wires != null) {
                    i = 0;
                    while (i < wires.length) {
                        if (((WireImpl)wires[i]).producerRef != null) {
                            doNotify = false;
                        }
                        ++i;
                    }
                }
                if (doNotify) {
                    this.notifyConsumerProducer(new NotificationEvent(null, (Consumer)service, null, null));
                }
            }
        }
    }

    void notifyListeners(Wire src, int type, Throwable t) {
        if (this.regWireAdmin == null) {
            return;
        }
        this.evtDisp.addEvent(new WireAdminEvent(this.regWireAdmin.getReference(), type, src, t));
    }

    void notifyConsumerProducer(NotificationEvent ne) {
        this.evtDisp.addNotificationEvent(ne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        if (this.regWireAdmin != null) {
            this.regWireAdmin.unregister();
            this.regWireAdmin = null;
        }
        if (this.regManagedFactory != null) {
            this.regManagedFactory.unregister();
            this.regManagedFactory = null;
        }
        Hashtable hashtable = this.wires;
        synchronized (hashtable) {
            Enumeration en = this.wires.elements();
            while (en.hasMoreElements()) {
                this.disconnectWire((WireImpl)en.nextElement());
            }
        }
        this.evtDisp.terminate();
        this.cm = null;
        this.wires.clear();
        this.wires = null;
        this.bc = null;
    }

    private static boolean caseVariants(Dictionary props) {
        int k = 0;
        int size = props.size();
        String[] keys = new String[size];
        try {
            Enumeration en = props.keys();
            while (en.hasMoreElements()) {
                keys[k] = (String)en.nextElement();
                ++k;
            }
        }
        catch (ClassCastException classCastException) {
            return true;
        }
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                if (keys[i].equalsIgnoreCase(keys[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static String getNextPID() {
        return PID_PREFIX + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasAConnectedWire(boolean isProducer, String pid) {
        Hashtable hashtable = this.wires;
        synchronized (hashtable) {
            String cPid;
            WireImpl wire;
            Enumeration en = this.wires.elements();
            do {
                if (en.hasMoreElements()) continue;
                return false;
            } while (!(wire = (WireImpl)en.nextElement()).isValid() || !wire.isConnected() || !(cPid = (String)wire.getProperties().get(isProducer ? "wireadmin.producer.pid" : "wireadmin.consumer.pid")).equals(pid));
            return true;
        }
    }
}

