/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ComponentStorage;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.storage.file.DBObject;
import org.eclipse.equinox.internal.util.io.ExternalizableDictionary;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class FileStorage
extends ComponentStorage {
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private BundleContext bc;
    private String[] dbBundlePath = new String[1];
    private String[] dbCompPath;
    private static String CUSTOM_DB_NAME = "SCR";
    private File file;
    private ExternalizableDictionary data;
    private StringBuffer pathBuffer;
    private String separator;

    public FileStorage(BundleContext bc) {
        String[] stringArray = new String[2];
        stringArray[1] = "COMPONENTS";
        this.dbCompPath = stringArray;
        this.data = new ExternalizableDictionary();
        this.pathBuffer = new StringBuffer();
        this.bc = bc;
        this.separator = bc.getProperty("path.separator");
        this.file = bc.getDataFile(CUSTOM_DB_NAME);
        try {
            if (this.file.exists()) {
                this.data.readObject(new BufferedInputStream(new FileInputStream(this.file)));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            Activator.log.error("[SCR] Error while loading components from data file " + this.file.getAbsolutePath(), (Throwable)e);
        }
        catch (Exception e) {
            Activator.log.error("[SCR] Error while loading components from data file " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    public Vector loadComponentDefinitions(long bundleID) {
        Bundle bundle = null;
        try {
            bundle = this.bc.getBundle(bundleID);
            Vector components = null;
            if (!Activator.DBSTORE) {
                return this.parseXMLDeclaration(bundle);
            }
            long lastModified = !Activator.getBoolean(PROP_CHECK_CONFIG) ? bundle.getLastModified() : this.getLastModifiedTimestamp(bundle);
            this.dbBundlePath[0] = String.valueOf(bundleID);
            String lastModifiedValue = (String)this.data.get(this.getPath(this.dbBundlePath));
            if (lastModifiedValue == null) {
                components = this.parseXMLDeclaration(bundle);
                if (components != null && components.size() != 0) {
                    this.data.put(this.getPath(this.dbBundlePath), "" + lastModified);
                    this.saveComponentDefinitions(components, bundleID);
                }
            } else {
                long dbLastModified = Long.parseLong(lastModifiedValue);
                if (lastModified > dbLastModified) {
                    components = this.parseXMLDeclaration(bundle);
                    if (components != null && components.size() != 0) {
                        this.data.put(this.getPath(this.dbBundlePath), "" + lastModified);
                        this.saveComponentDefinitions(components, bundleID);
                    }
                } else {
                    components = this.loadComponentsFromDB(bundle);
                }
            }
            return components;
        }
        catch (Throwable e) {
            Activator.log.error("[SCR] Unexpected exception while processing bundle with id " + bundleID + " : " + bundle, e);
            return null;
        }
    }

    private Vector loadComponentsFromDB(Bundle bundle) throws Exception {
        Vector components;
        ServiceComponent currentComponent;
        block4: {
            currentComponent = null;
            long bundleId = bundle.getBundleId();
            this.dbCompPath[0] = String.valueOf(bundleId);
            DBObject value = new DBObject();
            byte[] byteArr = (byte[])this.data.get(this.getPath(this.dbCompPath));
            ByteArrayInputStream tmpIn = new ByteArrayInputStream(byteArr);
            value.readObject(tmpIn);
            components = value.components;
            if (components != null) break block4;
            return null;
        }
        try {
            int i = 0;
            while (i < components.size()) {
                currentComponent = (ServiceComponent)components.elementAt(i);
                currentComponent.bundle = bundle;
                currentComponent.bc = bundle.getBundleContext();
                ++i;
            }
            return components;
        }
        catch (Throwable t) {
            Activator.log.error("[SCR] Error while loading components from DB", t);
            return null;
        }
    }

    public void deleteComponentDefinitions(long bundleID) throws Exception {
        this.dbBundlePath[0] = String.valueOf(bundleID);
        this.data.remove(this.getPath(this.dbBundlePath));
    }

    private void saveComponentDefinitions(Vector components, long bundleID) throws Exception {
        try {
            if (components == null || components.size() == 0) {
                return;
            }
            this.dbCompPath[0] = String.valueOf(bundleID);
            DBObject tmpObj = new DBObject(components);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            tmpObj.writeObject(buf);
            this.data.put(this.getPath(this.dbCompPath), buf.toByteArray());
            this.saveFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    private void saveFile() {
        block15: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(this.file);
                    try {
                        this.data.writeObject(fos);
                        fos.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (fos == null) break block15;
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String getPath(String[] path) {
        this.pathBuffer.setLength(0);
        int i = 0;
        while (i < path.length) {
            this.pathBuffer.append(path[i]).append(this.separator);
            ++i;
        }
        return this.pathBuffer.toString();
    }

    protected long getLastModifiedTimestamp(Bundle bundle) {
        if (bundle == null) {
            return 0L;
        }
        long result = 0L;
        ManifestElement[] elements = this.parseManifestHeader(bundle);
        int i = 0;
        while (i < elements.length) {
            URL componentURL = bundle.getEntry(elements[i].getValue());
            if (componentURL != null) {
                try {
                    URLConnection connection = componentURL.openConnection();
                    long lastModified = connection.getLastModified();
                    if (lastModified > result) {
                        result = lastModified;
                    }
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            ++i;
        }
        return result;
    }

    private ManifestElement[] parseManifestHeader(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String files = (String)headers.get("Service-Component");
        if (files == null) {
            return new ManifestElement[0];
        }
        try {
            return ManifestElement.parseHeader((String)"Service-Component", (String)files);
        }
        catch (BundleException e) {
            Activator.log.error("Error attempting parse manifest element header", (Throwable)e);
            return new ManifestElement[0];
        }
    }
}

