/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test.runner.junit4;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.corona.internal.test.runner.junit4.Activator;
import org.eclipse.corona.test.AbstractTestRunner;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.runner.junit4.JUnitTestResult;
import org.eclipse.corona.test.runner.junit4.TestRunListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.osgi.service.log.LogService;

public class JUnitTestRunner
extends AbstractTestRunner {
    private LogService logService = Activator.getDefault().getLogService();
    private static final String EVENT_TOPIC = "org/eclipse/corona/test/case";

    protected ITestResult runTestCases(ITestSuite iTestSuite) {
        Object[] objectArray = iTestSuite.listTestCases();
        TestRunListener testRunListener = new TestRunListener();
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)testRunListener);
        JUnitTestResult jUnitTestResult = new JUnitTestResult(iTestSuite);
        Result result = null;
        int n = 0;
        while (n < objectArray.length) {
            this.postTestEvent("test.start", iTestSuite, objectArray[n], null);
            if (iTestSuite.getRunnerType().equals("junit4")) {
                result = jUnitCore.run(new Class[]{objectArray[n].getClass()});
            } else if (iTestSuite.getRunnerType().equals("junit3_8")) {
                result = jUnitCore.run((Test)objectArray[n]);
            }
            this.postTestEvent("test.stop", iTestSuite, objectArray[n], result);
            jUnitTestResult.addJUnitResult(result);
            ++n;
        }
        return jUnitTestResult;
    }

    private void postTestEvent(String string, ITestSuite iTestSuite, Object object, Result result) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("timestamp", System.currentTimeMillis());
        hashtable.put("event", string);
        hashtable.put("test.suite", iTestSuite);
        hashtable.put("test.case", object.getClass().getName());
        String string2 = "executing";
        if (result != null) {
            string2 = result.wasSuccessful() ? "passed" : "failed";
        }
        hashtable.put("test.status", string2);
        Activator.getDefault().postEvent(EVENT_TOPIC, hashtable);
    }
}

