/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.io.PrintStream;
import java.text.NumberFormat;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TextListener
extends RunListener {
    private final PrintStream fWriter;

    public TextListener() {
        this(System.out);
    }

    public TextListener(PrintStream writer) {
        this.fWriter = writer;
    }

    public void testRunFinished(Result result) {
        this.printHeader(result.getRunTime());
        this.printFailures(result);
        this.printFooter(result);
    }

    public void testStarted(Description description) {
        this.fWriter.append('.');
    }

    public void testFailure(Failure failure) {
        this.fWriter.append('E');
    }

    public void testIgnored(Description description) {
        this.fWriter.append('I');
    }

    private PrintStream getWriter() {
        return this.fWriter;
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        this.getWriter().println("Time: " + this.elapsedTimeAsString(runTime));
    }

    protected void printFailures(Result result) {
        if (result.getFailureCount() == 0) {
            return;
        }
        if (result.getFailureCount() == 1) {
            this.getWriter().println("There was " + result.getFailureCount() + " failure:");
        } else {
            this.getWriter().println("There were " + result.getFailureCount() + " failures:");
        }
        int i = 1;
        for (Failure each : result.getFailures()) {
            this.printFailure(each, i++);
        }
    }

    protected void printFailure(Failure failure, int count) {
        this.printFailureHeader(failure, count);
        this.printFailureTrace(failure);
    }

    protected void printFailureHeader(Failure failure, int count) {
        this.getWriter().println(count + ") " + failure.getTestHeader());
    }

    protected void printFailureTrace(Failure failure) {
        this.getWriter().print(failure.getTrace());
    }

    protected void printFooter(Result result) {
        if (result.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + result.getRunCount() + " test" + (result.getRunCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + result.getRunCount() + ",  Failures: " + result.getFailureCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }
}

