/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test.cases;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.corona.diagnostic.IDiagnosticData;
import org.eclipse.corona.internal.test.cases.Activator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractTestDiagnosticData {
    private static ServiceReference[] srvReferences = null;
    private String filter;
    private IDiagnosticData diagData;
    private String srvName;

    public AbstractTestDiagnosticData(String string) {
        this.srvName = string;
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        this.filter = "(component.name=" + string + ")";
        try {
            srvReferences = bundleContext.getServiceReferences(IDiagnosticData.class.getName(), this.filter);
            if (srvReferences != null && srvReferences.length > 0) {
                this.diagData = (IDiagnosticData)bundleContext.getService(srvReferences[0]);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            invalidSyntaxException.printStackTrace();
        }
    }

    @AfterClass
    public static void afterClass() {
        if (srvReferences != null) {
            BundleContext bundleContext = Activator.getDefault().getBundleContext();
            int n = 0;
            while (n < srvReferences.length) {
                bundleContext.ungetService(srvReferences[n]);
                ++n;
            }
        }
    }

    @Test
    public void validateName() {
        Assert.assertNotNull((String)("DiagnosticData service not available: " + this.srvName), (Object)this.diagData);
        String string = this.diagData.getName();
        Assert.assertNotNull((String)"DiagnosticData service name not available", (Object)string);
    }

    @Test
    public void validateVersion() {
        Assert.assertNotNull((String)("DiagnosticData service not available: " + this.srvName), (Object)this.diagData);
        String string = this.diagData.getVersion();
        Assert.assertNotNull((String)"DiagnosticData service version not available", (Object)string);
    }

    @Test
    public void validateType() {
        Assert.assertNotNull((String)("DiagnosticData service not available: " + this.srvName), (Object)this.diagData);
        String string = this.diagData.getType();
        Assert.assertNotNull((String)"DiagnosticData service type not available", (Object)string);
    }

    @Test
    public void testCapture() {
        Assert.assertNotNull((String)("DiagnosticData service not available: " + this.srvName), (Object)this.diagData);
        this.diagData.capture();
    }

    @Test
    public void testSave() throws IOException {
        Assert.assertNotNull((String)("DiagnosticData service not available: " + this.srvName), (Object)this.diagData);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.diagData.capture();
        this.diagData.save((OutputStream)byteArrayOutputStream);
        Assert.assertTrue((String)"Not able to save Diagnostic Data", (byteArrayOutputStream.size() > 0 ? 1 : 0) != 0);
    }
}

