/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test.cases;

import org.eclipse.corona.CoronaException;
import org.eclipse.corona.internal.test.cases.Activator;
import org.eclipse.corona.server.IApplicationManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class TestApplication {
    private static final String TEST_CASES_APPLICATION = "org.eclipse.corona.test.cases.application";
    private BundleContext ctxBundle = Activator.getDefault().getBundleContext();
    private LogService logService = Activator.getDefault().getLogService();
    private ServiceTracker srvTrackerAppManager;
    private IApplicationManager appManager;

    @Before
    public void setup() throws InterruptedException {
        this.srvTrackerAppManager = new ServiceTracker(this.ctxBundle, IApplicationManager.class.getName(), null);
        this.srvTrackerAppManager.open();
        this.appManager = (IApplicationManager)this.srvTrackerAppManager.waitForService(0L);
    }

    @After
    public void teadDown() {
        this.srvTrackerAppManager.close();
        this.appManager = null;
    }

    @Test
    public void verifyApplicationLifecycle() throws Exception {
        boolean bl = this.appManager.isApplicationRunning(TEST_CASES_APPLICATION);
        Assert.assertFalse((String)"application already running: org.eclipse.corona.test.cases.application", (boolean)bl);
        this.appManager.startApplication(TEST_CASES_APPLICATION);
        bl = this.appManager.isApplicationRunning(TEST_CASES_APPLICATION);
        Assert.assertTrue((String)"application did not start: org.eclipse.corona.test.cases.application", (boolean)bl);
        this.appManager.stopApplication(TEST_CASES_APPLICATION);
        bl = this.appManager.isApplicationRunning(TEST_CASES_APPLICATION);
        Assert.assertFalse((String)"application did not stop: org.eclipse.corona.test.cases.application", (boolean)bl);
    }

    @Test
    public void countRunningApplications() throws CoronaException {
        if (this.appManager.isApplicationRunning(TEST_CASES_APPLICATION)) {
            this.appManager.stopApplication(TEST_CASES_APPLICATION);
        }
        int n = this.appManager.countRunningApplications();
        this.appManager.startApplication(TEST_CASES_APPLICATION);
        int n2 = this.appManager.countRunningApplications();
        this.appManager.stopApplication(TEST_CASES_APPLICATION);
        Assert.assertTrue((n < n2 ? 1 : 0) != 0);
    }

    @Test
    public void invalidStartApplication() throws Exception {
        try {
            this.appManager.startApplication("test.invalid.application");
            Assert.fail((String)"should not be able to start invalid application");
        }
        catch (CoronaException coronaException) {}
    }

    @Test
    public void invalidStopApplication() throws Exception {
        try {
            this.appManager.stopApplication("test.invalid.application");
            Assert.fail((String)"should not be able to stop invalid application");
        }
        catch (CoronaException coronaException) {}
    }
}

