/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.internal.test;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.PriorityQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.internal.test.Activator;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestRunner;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.corona.test.InvalidTestSuite;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;

public class TestManager
implements ITestManager {
    private LogService logService;
    private Hashtable<String, ITestRunner> listTestRunners = new Hashtable();
    private EventAdmin eventAdmin;

    public TestManager() {
        this.logService = Activator.getDefault().getLogService();
    }

    protected void activate(ComponentContext componentContext) {
        componentContext.getBundleContext();
        this.initTestRunners();
        this.eventAdmin = (EventAdmin)componentContext.locateService("EventAdmin");
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    private void initTestRunners() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.test.runner");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    ITestRunner iTestRunner;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                    try {
                        iTestRunner = (ITestRunner)iConfigurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException coreException) {
                        this.logService.log(2, "Unable to create ITestRunner extension", (Throwable)coreException);
                        break block4;
                    }
                    String string = iConfigurationElement.getAttribute("name");
                    iTestRunner.setName(string);
                    String string2 = iConfigurationElement.getAttribute("type");
                    iTestRunner.setType(string2);
                    this.listTestRunners.put(string2, iTestRunner);
                }
                ++n2;
            }
        }
    }

    public ITestSummary[] runAllTestSuites() throws Exception {
        ArrayList<ITestSummary> arrayList = new ArrayList<ITestSummary>();
        ITestSuite[] iTestSuiteArray = this.testSuites();
        int n = 0;
        while (n < iTestSuiteArray.length) {
            ITestSummary iTestSummary = this.runTestSuite(iTestSuiteArray[n]);
            arrayList.add(iTestSummary);
            ++n;
        }
        return arrayList.toArray(new ITestSummary[arrayList.size()]);
    }

    public ITestSummary runTestSuite(ITestSuite iTestSuite) {
        ITestRunner iTestRunner = this.listTestRunners.get(iTestSuite.getRunnerType());
        if (iTestRunner == null) {
            this.logService.log(2, "Could not find ITestRunner of type: " + iTestSuite.getRunnerType());
            return null;
        }
        this.postTestEvent("test.start", iTestSuite, null);
        this.logService.log(3, "Running test suite: " + iTestSuite.getName());
        ITestSummary iTestSummary = iTestRunner.runTestSuite(iTestSuite);
        this.postTestEvent("test.stop", iTestSuite, iTestSummary);
        return iTestSummary;
    }

    private void postTestEvent(String string, ITestSuite iTestSuite, ITestSummary iTestSummary) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("timestamp", System.currentTimeMillis());
        hashtable.put("event", string);
        hashtable.put("test.suite", iTestSuite);
        String string2 = "executing";
        if (iTestSummary != null) {
            string2 = iTestSummary.getTestResult().wasSuccessful() ? "passed" : "failed";
            hashtable.put("test.status", string2);
        }
        Event event = new Event("org/eclipse/corona/test", hashtable);
        this.eventAdmin.postEvent(event);
    }

    public ITestSuite[] testSuites() {
        IExtensionPoint iExtensionPoint;
        PriorityQueue<ITestSuite> priorityQueue = new PriorityQueue<ITestSuite>();
        BundleContext bundleContext = Activator.getDefault().getBundleContext();
        try {
            ServiceReference[] serviceReferenceArray = bundleContext.getServiceReferences(ITestSuite.class.getName(), null);
            if (serviceReferenceArray != null) {
                ServiceReference[] serviceReferenceArray2 = serviceReferenceArray;
                int n = serviceReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    iExtensionPoint = serviceReferenceArray2[n2];
                    ITestSuite iTestSuite = (ITestSuite)bundleContext.getService((ServiceReference)iExtensionPoint);
                    priorityQueue.add(iTestSuite);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.logService.log(1, "Unable to lookup OSGi srvref of ITestSuite", (Throwable)invalidSyntaxException);
        }
        if ((iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.corona.test.suite")) != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                ITestSuite iTestSuite;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
                try {
                    iTestSuite = (ITestSuite)iConfigurationElement.createExecutableExtension("class");
                }
                catch (Throwable throwable) {
                    this.logService.log(1, "Unable to create ext point ITestSuite", throwable);
                    iTestSuite = new InvalidTestSuite(throwable);
                }
                iTestSuite.setName(iConfigurationElement.getAttribute("name"));
                String string = iConfigurationElement.getAttribute("level");
                if (string == null) {
                    string = "5";
                }
                iTestSuite.setLevel(string);
                String string2 = iConfigurationElement.getAttribute("runner");
                if (string2 == null) {
                    string2 = "junit4";
                }
                iTestSuite.setRunnerType(string2);
                priorityQueue.add(iTestSuite);
                ++n3;
            }
        }
        return priorityQueue.toArray(new ITestSuite[priorityQueue.size()]);
    }
}

