/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corona.internal.test.Activator;
import org.eclipse.corona.test.ITestManager;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.corona.test.TestSummaryDocBuilder;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Application
implements IApplication,
EventHandler {
    private LogService logService = Activator.getDefault().getLogService();
    private transient IApplicationContext ctxApplication;
    private transient BundleContext ctxBundle;
    private transient boolean stopRequest = false;
    private boolean consoleDisplay = false;
    public static final Integer TEST_OK = EXIT_OK;
    public static final Integer TEST_ERR_TEST_MANAGER = new Integer(-200);
    public static final Integer TEST_ERR_TEST_SUMMARY = new Integer(-201);
    public static final Integer TEST_ERR_DOC_BUILDER = new Integer(-202);
    public static final Integer TEST_ERR_SAVE_RESULTS = new Integer(-203);

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        this.logService.log(3, "starting test application");
        this.ctxApplication = iApplicationContext;
        this.ctxBundle = Activator.getDefault().getBundleContext();
        String[] stringArray = new String[]{"event.topics", "org/eclipse/corona/test/*"};
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        hashtable.put("event.topics", stringArray);
        ServiceRegistration serviceRegistration = this.ctxBundle.registerService(EventHandler.class.getName(), (Object)this, hashtable);
        this.ctxApplication.applicationRunning();
        Integer n = new Integer(-51);
        try {
            n = this.testAll();
        }
        catch (Throwable throwable) {
            this.logService.log(2, "Unable to performa all test suites", throwable);
        }
        Thread.sleep(3000L);
        serviceRegistration.unregister();
        this.logService.log(4, "exiting test application");
        return n;
    }

    public void stop() {
        this.logService.log(4, "stopping test application");
        this.stopRequest = true;
    }

    public Integer testAll() {
        File file;
        TestSummaryDocBuilder testSummaryDocBuilder;
        Object object;
        Object[] objectArray;
        this.logService.log(4, "Running ALL test cases...");
        ArrayList<ITestSummary> arrayList = new ArrayList<ITestSummary>();
        ITestManager iTestManager = this.getTestManager();
        if (iTestManager == null) {
            this.logService.log(2, "Warning: unable to locate TestManager");
            return TEST_ERR_TEST_MANAGER;
        }
        try {
            objectArray = iTestManager.testSuites();
            int n = 0;
            while (n < objectArray.length) {
                object = iTestManager.runTestSuite(objectArray[n]);
                if (object != null) {
                    arrayList.add((ITestSummary)object);
                }
                if (this.stopRequest) {
                    this.logService.log(2, "Execution of test suites has been interrupted");
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.logService.log(2, "ERROR: " + exception.getMessage(), (Throwable)exception);
            return TEST_ERR_TEST_MANAGER;
        }
        objectArray = arrayList.toArray(new ITestSummary[arrayList.size()]);
        if (objectArray == null) {
            this.logService.log(2, "Warning: no TestSummary results");
            return TEST_ERR_TEST_SUMMARY;
        }
        this.logService.log(4, "...creating test summary xml");
        try {
            testSummaryDocBuilder = new TestSummaryDocBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.logService.log(2, "Unable to build XML TestSummary", (Throwable)parserConfigurationException);
            return TEST_ERR_DOC_BUILDER;
        }
        Object object2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            testSummaryDocBuilder.addTestSummary((ITestSummary)object);
            this.displayTestSummary((ITestSummary)object);
            ++n2;
        }
        object = "TestSummary_" + Long.toString(System.currentTimeMillis()) + ".xml";
        this.logService.log(4, "...test summary xml: " + (String)object);
        try {
            IPath iPath = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
            object2 = iPath.toFile();
            file = new File((File)object2, (String)object);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(testSummaryDocBuilder.getDocument());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            this.logService.log(2, "Failed to save test summary", throwable);
            return TEST_ERR_SAVE_RESULTS;
        }
        this.logService.log(3, "TestSummary results: " + file.getAbsolutePath());
        return TEST_OK;
    }

    private ITestManager getTestManager() {
        ServiceTracker serviceTracker = new ServiceTracker(this.ctxBundle, ITestManager.class.getName(), null);
        serviceTracker.open();
        ITestManager iTestManager = null;
        try {
            iTestManager = (ITestManager)serviceTracker.waitForService(15000L);
        }
        catch (Exception exception) {
            this.logService.log(2, "Unable to get ITestManager service", (Throwable)exception);
        }
        serviceTracker.close();
        return iTestManager;
    }

    private void displayTestSummary(ITestSummary iTestSummary) {
        this.logService.log(3, iTestSummary.toString());
    }

    public void handleEvent(Event event) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Test Progress Event: ");
        String string = (String)event.getProperty("event");
        stringBuffer.append("state=" + string + " ");
        string = (String)event.getProperty("test.status");
        string = string == null ? "unknown" : string;
        stringBuffer.append("status=" + string + " ");
        ITestSuite iTestSuite = (ITestSuite)event.getProperty("test.suite");
        string = iTestSuite.getName();
        stringBuffer.append("suite=" + string + " ");
        String string2 = (String)event.getProperty("test.case");
        string = string2 == null ? "" : string2;
        stringBuffer.append("case=" + string + " ");
        this.logService.log(3, stringBuffer.toString());
    }
}

