/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test.runner.junit4;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;
import org.eclipse.corona.internal.test.runner.junit4.Activator;
import org.eclipse.corona.test.AbstractTestRunner;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.runner.junit4.JUnitTestResult;
import org.eclipse.corona.test.runner.junit4.TestRunListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

public class CTFJUnitTestRunner
extends AbstractTestRunner {
    private Logger logger = Logger.getLogger((String)CTFJUnitTestRunner.class.getName());
    private static final String EVENT_TOPIC = "org/eclipse/corona/test/case";

    protected ITestResult runTestCases(ITestSuite iTestSuite) throws Exception {
        Object[] objectArray = iTestSuite.listTestCases();
        TestRunListener testRunListener = new TestRunListener();
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)testRunListener);
        JUnitTestResult jUnitTestResult = new JUnitTestResult(iTestSuite);
        jUnitTestResult.setCTFTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.EXECUTING);
        int n = 0;
        while (n < objectArray.length) {
            String string;
            ClassLoader classLoader;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = false;
            if ("java.lang.Class".equals(objectArray[n].getClass().getName())) {
                classLoader = ((Class)objectArray[n]).getClassLoader();
                string = ((Class)objectArray[n]).getName();
            } else if ("junit.framework.TestSuite".equals(objectArray[n].getClass().getName())) {
                classLoader = objectArray[n].getClass().getClassLoader();
                string = objectArray[n].toString();
            } else {
                classLoader = objectArray[n].getClass().getClassLoader();
                string = objectArray[n].getClass().getName();
            }
            this.postJUnitTestSuiteEvent("test.start", iTestSuite, string, ITestResult.TestSuiteExecutionStatus.EXECUTING.label());
            JUnitTest jUnitTest = new JUnitTest(string);
            Properties properties = System.getProperties();
            properties.setProperty("CTFSuite", iTestSuite.getName());
            properties.setProperty("ContributorLabel", iTestSuite.getContributorLabel());
            jUnitTest.setProperties((Hashtable)properties);
            XMLJUnitResultFormatter xMLJUnitResultFormatter = new XMLJUnitResultFormatter();
            String string2 = "";
            try {
                string2 = this.getXMLTestResultFile(String.valueOf(iTestSuite.getName()) + "_-_" + jUnitTest.getName());
            }
            catch (Exception exception) {
                this.logger.error((Object)"Exception while trying to get XML Test Result filename.", (Throwable)exception);
                throw exception;
            }
            try {
                xMLJUnitResultFormatter.setOutput((OutputStream)new FileOutputStream(new File(string2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error((Object)("Unable to create XML Test Result File: " + this.getXMLTestResultFile(jUnitTest.getName()) + " Validate the target folder exists and proper security rights are assigned."), (Throwable)fileNotFoundException);
                throw fileNotFoundException;
            }
            JUnitTestRunner jUnitTestRunner = new JUnitTestRunner(jUnitTest, bl, bl3, bl2, bl4, classLoader);
            jUnitTestRunner.addFormatter((JUnitResultFormatter)xMLJUnitResultFormatter);
            this.logger.info((Object)("Running JUnit test suite: " + string));
            jUnitTestRunner.run();
            this.logger.info((Object)("JUnit test suite completed in: " + jUnitTest.getRunTime() / 1000L + " seconds"));
            this.logger.info((Object)("Saving JUnit test suite results to " + this.getXMLTestResultFile(jUnitTest.getName())));
            jUnitTestResult.addFailureCount(jUnitTest.failureCount());
            jUnitTestResult.addRunCount(jUnitTest.runCount());
            jUnitTestResult.addErrorCount(jUnitTest.errorCount());
            jUnitTestResult.addRunTime(jUnitTest.getRunTime());
            if (jUnitTestRunner.getRetCode() == 0) {
                jUnitTestResult.addTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.SUCCESS);
            } else {
                if (jUnitTest.failureCount() > 0L) {
                    jUnitTestResult.addTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.FAILURES);
                }
                if (jUnitTest.errorCount() > 0L) {
                    jUnitTestResult.addTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.ERRORS);
                }
            }
            this.postJUnitTestSuiteEvent("test.stop", iTestSuite, string, ITestResult.TestSuiteExecutionStatus.getTestSuiteExecutionStatus((int)jUnitTestRunner.getRetCode()).label());
            ++n;
        }
        List list = jUnitTestResult.getTestSuiteExecutionStatuses();
        if (list.contains(ITestResult.TestSuiteExecutionStatus.ERRORS)) {
            jUnitTestResult.setCTFTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.ERRORS);
        } else if (list.contains(ITestResult.TestSuiteExecutionStatus.FAILURES)) {
            jUnitTestResult.setCTFTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.FAILURES);
        } else {
            jUnitTestResult.setCTFTestSuiteExecutionStatus(ITestResult.TestSuiteExecutionStatus.SUCCESS);
        }
        return jUnitTestResult;
    }

    private void postJUnitTestSuiteEvent(String string, ITestSuite iTestSuite, String string2, String string3) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("timestamp", System.currentTimeMillis());
        hashtable.put("event", string);
        hashtable.put("test.suite", iTestSuite);
        hashtable.put("test.case", string2);
        hashtable.put("test.status", string3);
        Activator.getDefault().postEvent(EVENT_TOPIC, hashtable);
    }

    private String getXMLTestResultFile(String string) throws Exception {
        String string2 = System.getProperty("ctf.testresults.xml.output.dir");
        if (string2 == null || "".equals(string2.trim())) {
            string2 = System.getProperty("java.io.tmpdir");
            this.logger.warn((Object)("VM Argument ctf.testresults.xml.output.dir is not defined.  Currently using default system temp dir: " + System.getProperty("java.io.tmpdir")));
        }
        String string3 = String.valueOf(string2) + File.separator + "TEST-" + string + ".xml";
        return string3;
    }
}

