/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.eclipse.corona.test.ITestResult;
import org.eclipse.corona.test.ITestRunner;
import org.eclipse.corona.test.ITestSuite;
import org.eclipse.corona.test.ITestSummary;
import org.eclipse.corona.test.TestMergedOutput;
import org.eclipse.corona.test.TestOutput;
import org.eclipse.corona.test.TestResultsBuilder;
import org.eclipse.corona.test.TestSummary;

public abstract class AbstractTestRunner
implements ITestRunner {
    private Logger logger = Logger.getLogger((String)AbstractTestRunner.class.getName());
    private String name;
    private String type;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public ITestSummary runTestSuite(ITestSuite iTestSuite) {
        TestSummary testSummary;
        block5: {
            this.logger.info((Object)"entering runTestSuite()");
            PrintStream printStream = System.out;
            PrintStream printStream2 = System.err;
            testSummary = new TestSummary();
            TestMergedOutput testMergedOutput = new TestMergedOutput();
            try {
                try {
                    TestOutput testOutput = new TestOutput("sysout", testMergedOutput);
                    System.setOut(new PrintStream(testOutput));
                    TestOutput testOutput2 = new TestOutput("syserr", testMergedOutput);
                    System.setErr(new PrintStream(testOutput2));
                    ITestResult iTestResult = null;
                    iTestResult = iTestSuite.isValid() ? this.runTestCases(iTestSuite) : TestResultsBuilder.createTestResult(iTestSuite);
                    testSummary.initialize(iTestSuite, iTestResult, testMergedOutput.getOutput());
                    testSummary.stop();
                }
                catch (Exception exception) {
                    String string = TestSummary.getTestMergedOutput(testMergedOutput.getOutput());
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    this.logger.error((Object)("Error running JUnit for ITestSuite: " + iTestSuite.getName()), (Throwable)exception);
                    this.logger.error((Object)string);
                    testSummary = null;
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(printStream);
                System.setErr(printStream2);
                throw throwable;
            }
            System.setOut(printStream);
            System.setErr(printStream2);
        }
        this.logger.info((Object)"exiting runTestSuite()");
        return testSummary;
    }

    protected abstract ITestResult runTestCases(ITestSuite var1) throws Exception;

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        this.type = string;
    }
}

