/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.test;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.corona.test.ITestSuite;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractTestSuite
implements ITestSuite {
    private ArrayList<Object> listTestCases = new ArrayList();
    protected Properties properties = new Properties();
    protected boolean valid = true;
    protected Throwable xception;
    protected String contributorLabel;

    protected AbstractTestSuite() {
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary dictionary = componentContext.getProperties();
        Enumeration enumeration = componentContext.getProperties().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)dictionary.get(string);
            this.properties.setProperty(string, string2);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void addTestCase(Class clazz) {
        this.listTestCases.add(clazz);
    }

    protected void addTestCase(Object object) {
        this.listTestCases.add(object);
    }

    public Object[] listTestCases() {
        return this.listTestCases.toArray(new Object[this.listTestCases.size()]);
    }

    public String getProperty(String string, String string2) {
        String string3 = (String)this.properties.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void setName(String string) {
        this.properties.setProperty("name", string);
    }

    public String getName() {
        String string = this.getProperty("name", "UnknownTestSuite");
        return string;
    }

    public void setLevel(int n) {
        this.setLevel(Integer.toString(n));
    }

    public void setLevel(String string) {
        if (string == null) {
            string = "5";
        }
        this.properties.setProperty("level", string);
    }

    public int getLevel() {
        String string = this.getProperty("level", "5");
        return Integer.parseInt(string);
    }

    public int compareTo(ITestSuite iTestSuite) {
        int n = 0;
        if (this.getLevel() < iTestSuite.getLevel()) {
            n = -1;
        } else if (this.getLevel() > iTestSuite.getLevel()) {
            n = 1;
        }
        return n;
    }

    public String getRunnerType() {
        String string = this.getProperty("runner", "junit4");
        return string;
    }

    public void setRunnerType(String string) {
        this.properties.setProperty("runner", string);
    }

    public Throwable getException() {
        return this.xception;
    }

    public void setContributorLabel(String string) {
        this.contributorLabel = string;
    }

    public String getContributorLabel() {
        return this.contributorLabel;
    }
}

