/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corona.diag.data.bundles;

import java.util.ArrayList;
import org.eclipse.corona.diag.data.bundles.BundleDiagnosticData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleDiagnosticDataFactory {
    private static final String PROPERTY_LIST = "PropertyList";

    public BundleDiagnosticData[] listBundleDiagnostics(Document document) {
        ArrayList<BundleDiagnosticData> arrayList = new ArrayList<BundleDiagnosticData>();
        Node node = document.getFirstChild();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("Bundle")) {
                BundleDiagnosticData bundleDiagnosticData = this.createBundleDiagnosticData(node2);
                arrayList.add(bundleDiagnosticData);
            }
            ++n;
        }
        return arrayList.toArray(new BundleDiagnosticData[arrayList.size()]);
    }

    private BundleDiagnosticData createBundleDiagnosticData(Node node) {
        BundleDiagnosticData bundleDiagnosticData = new BundleDiagnosticData();
        Node node2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        node2 = namedNodeMap.getNamedItem("id");
        bundleDiagnosticData.setId(node2.getNodeValue());
        node2 = namedNodeMap.getNamedItem("state");
        bundleDiagnosticData.setState(node2.getNodeValue());
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node3 = nodeList.item(n);
            if (node3.getNodeName().equals(PROPERTY_LIST)) {
                this.createBundleProperties(bundleDiagnosticData, node3);
            }
            ++n;
        }
        return bundleDiagnosticData;
    }

    private void createBundleProperties(BundleDiagnosticData bundleDiagnosticData, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("Property")) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("name");
                String string = node3.getNodeValue();
                String string2 = node2.getTextContent();
                bundleDiagnosticData.addProperty(string, string2);
            }
            ++n;
        }
    }
}

