/*
 * Copyright (c) 2007-2008 Compuware Corporation and others.
 * 
 * All rights reserved. This program and the accompanying 
 * materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at:
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 */
package org.eclipse.corona.test;

/**
 * Run a Corona test suite
 * 
 */
public interface ITestRunner {

	/*
	 * define extension point constants
	 */
	public static final String EXT_POINT = "org.eclipse.corona.test.runner";
	public static final String PROPERTY_CLASS = "class";
	public static final String PROPERTY_NAME = "name";
	public static final String PROPERTY_TYPE = "type";

	/**
	 * Run a suite of test
	 * 
	 * @param testSuite
	 * @return test summary results
	 */
	public ITestSummary runTestSuite(ITestSuite testSuite);

	public void setName(String name);
	public String getName();

	public void setType(String type);
	public String getType();
}
